/*
 * Decompiled with CFR 0.152.
 */
package piv;

import classes.PIVAPIException;
import classes.PivApiWrapper;
import piv.Helper;
import ui.MainWindow;
import ui.ScenarioInterface;

public class Scenarios
implements ScenarioInterface {
    private final byte m_algoID = (byte)7;
    private long m_hCard = -1L;
    private final byte[] m_dataToSign = new byte[]{48, 32, 48, 12, 6, 8, 42, -122, 72, -122, -9, 13, 2, 5, 5, 0, 4, 16, -127, -116, 110, 96, 26, 36, -9, 39, 80, -38, 15, 108, -101, -114, -66, 40};
    private int m_nbObjects = 14;
    private int m_nbCertificates = 3;
    private String[] m_listLabels = new String[this.m_nbObjects];
    private String[] m_listOIDs = new String[this.m_nbObjects];
    private boolean[] m_listPINNeed = new boolean[this.m_nbObjects];
    private String[] m_readerList = null;
    private String[] m_certOnCurrentCardLabelsList = null;
    private String[] m_certOnCurrentCardOIDsList = null;
    private int[] m_certIndexList = new int[this.m_nbCertificates];
    private boolean[] m_certPresence = new boolean[this.m_nbCertificates];
    private int m_cardCertsCnt = 0;
    private byte[] m_keyReferenceList = new byte[this.m_nbCertificates];
    private int[] m_certsAuthentNb = new int[this.m_nbCertificates];
    private String[] m_objOnCurrentCardLabelsList = null;
    private String[] m_objOnCurrentCardOIDsList = null;
    private boolean[] m_objPresence = new boolean[this.m_nbObjects];
    private int m_cardObjCnt = 0;
    private int m_selectedObject = 0;
    private MainWindow m_mainWindow = new MainWindow(this, new String[]{"PIV signature", "PIV objects read"}, "HID Global PIV API Java sample");
    private PivApiWrapper myPivApi = null;

    public Scenarios() {
        try {
            this.myPivApi = new PivApiWrapper();
            if (this.myPivApi == null) {
                this.m_mainWindow.print("myPivApi is null", MainWindow.LogType.ScenarioError);
            }
        }
        catch (Exception exception) {
            this.m_mainWindow.print("Exception : " + exception.toString(), MainWindow.LogType.ScenarioError);
            System.exit(-1);
        }
        this.m_mainWindow.print("------------------------------------------------------------------------------------");
        this.m_mainWindow.print("HID Global PIV API Java Sample");
        this.m_mainWindow.print("Copyright \u00a9 2016 HID Global Corporation/ASSA ABLOY AB. All rights reserved.");
        this.m_mainWindow.print("------------------------------------------------------------------------------------");
        String string = null;
        try {
            string = this.myPivApi.pivMiddlewareVersion();
        }
        catch (Exception exception) {
            this.m_mainWindow.print("pivMiddlewareVersion failed with error " + exception.toString(), MainWindow.LogType.ScenarioError);
            System.exit(-1);
        }
        String string2 = "This sample demonstrates how to use the PIV API version \"" + string + "\" provided by ActivClient 7.1 from a Java program.\n" + "It implements following scenarios:\n" + "        -    How to use a PIV signature key to sign some data.\n" + "        -    How to read PIV objects from the card.\n";
        this.m_mainWindow.showMessageDialog(string2);
        this.m_listLabels[0] = new String("Card Capability Container");
        this.m_listOIDs[0] = new String("2.16.840.1.101.3.7.1.219.0");
        this.m_listPINNeed[0] = false;
        this.m_listLabels[1] = new String("Card Holder Unique Identifier");
        this.m_listOIDs[1] = new String("2.16.840.1.101.3.7.2.48.0");
        this.m_listPINNeed[1] = false;
        this.m_listLabels[2] = new String("X.509 Certificate for PIV Authentication");
        this.m_listOIDs[2] = new String("2.16.840.1.101.3.7.2.1.1");
        this.m_listPINNeed[2] = false;
        this.m_certIndexList[0] = 2;
        this.m_keyReferenceList[0] = -102;
        this.m_certsAuthentNb[0] = 1;
        this.m_listLabels[3] = new String("Card Holder Fingerprints");
        this.m_listOIDs[3] = new String("2.16.840.1.101.3.7.2.96.16");
        this.m_listPINNeed[3] = true;
        this.m_listLabels[4] = new String("Security Object");
        this.m_listOIDs[4] = new String("2.16.840.1.101.3.7.2.144.0");
        this.m_listPINNeed[4] = false;
        this.m_listLabels[5] = new String("Card Holder Facial Image");
        this.m_listOIDs[5] = new String("2.16.840.1.101.3.7.2.96.48");
        this.m_listPINNeed[5] = true;
        this.m_listLabels[6] = new String("Printed Information");
        this.m_listOIDs[6] = new String("2.16.840.1.101.3.7.2.48.1");
        this.m_listPINNeed[6] = true;
        this.m_listLabels[7] = new String("X.509 Certificate for Digital Signature");
        this.m_listOIDs[7] = new String("2.16.840.1.101.3.7.2.1.0");
        this.m_listPINNeed[7] = false;
        this.m_certIndexList[1] = 7;
        this.m_keyReferenceList[1] = -100;
        this.m_certsAuthentNb[1] = 2;
        this.m_listLabels[8] = new String("X.509 Certificate for Key Management");
        this.m_listOIDs[8] = new String("2.16.840.1.101.3.7.2.1.2");
        this.m_listPINNeed[8] = false;
        this.m_listLabels[9] = new String("X.509 Certificate for Card Authentication");
        this.m_listOIDs[9] = new String("2.16.840.1.101.3.7.2.5.0");
        this.m_listPINNeed[9] = false;
        this.m_certIndexList[2] = 9;
        this.m_keyReferenceList[2] = -98;
        this.m_certsAuthentNb[2] = 0;
        this.m_listLabels[10] = new String("Discovery Object");
        this.m_listOIDs[10] = new String("2.16.840.1.101.3.7.2.96.80");
        this.m_listPINNeed[10] = false;
        this.m_listLabels[11] = new String("Key History Object");
        this.m_listOIDs[11] = new String("2.16.840.1.101.3.7.2.96.96");
        this.m_listPINNeed[11] = false;
        this.m_listLabels[12] = new String("Retired X.509 Certificate for Key Management 1");
        this.m_listOIDs[12] = new String("2.16.840.1.101.3.7.2.16.1");
        this.m_listPINNeed[12] = false;
        this.m_listLabels[13] = new String("Cardholder Iris Image");
        this.m_listOIDs[13] = new String("2.16.840.1.101.3.7.2.16.21");
        this.m_listPINNeed[13] = true;
    }

    public void pivSignature() {
        this.m_mainWindow.print("Starting PIV signature scenario...", MainWindow.LogType.ScenarioBoundary);
        if (!this.preamble()) {
            this.m_mainWindow.print("PIV signature scenario aborted!", MainWindow.LogType.ScenarioBoundary);
            return;
        }
        if (!this.getSelectedCertificate()) {
            this.postamble(false);
            this.m_mainWindow.print("PIV signature scenario aborted!", MainWindow.LogType.ScenarioBoundary);
            return;
        }
        switch (this.m_certsAuthentNb[this.m_selectedObject]) {
            case 0: {
                this.signData(this.m_keyReferenceList[this.m_selectedObject], (byte)7);
                this.signData(this.m_keyReferenceList[this.m_selectedObject], (byte)7);
                this.postamble(false);
                break;
            }
            case 1: {
                if (!this.logIntoCardApplication()) {
                    this.postamble(false);
                    this.m_mainWindow.print("PIV signature scenario aborted!", MainWindow.LogType.ScenarioBoundary);
                    return;
                }
                this.signData(this.m_keyReferenceList[this.m_selectedObject], (byte)7);
                this.signData(this.m_keyReferenceList[this.m_selectedObject], (byte)7);
                this.postamble(true);
                break;
            }
            case 2: {
                if (!this.logIntoCardApplication()) {
                    this.postamble(false);
                    this.m_mainWindow.print("PIV signature scenario aborted!", MainWindow.LogType.ScenarioBoundary);
                    return;
                }
                this.signData(this.m_keyReferenceList[this.m_selectedObject], (byte)7);
                if (!this.logIntoCardApplication()) {
                    this.postamble(false);
                    this.m_mainWindow.print("PIV signature scenario aborted!", MainWindow.LogType.ScenarioBoundary);
                    return;
                }
                this.signData(this.m_keyReferenceList[this.m_selectedObject], (byte)7);
                this.postamble(true);
                break;
            }
            default: {
                this.postamble(false);
            }
        }
        this.m_mainWindow.print("PIV signature scenario completed.", MainWindow.LogType.ScenarioBoundary);
    }

    public void pivObjectsRead() {
        this.m_mainWindow.print("Starting PIV objects read scenario...", MainWindow.LogType.ScenarioBoundary);
        if (!this.preamble()) {
            this.postamble(false);
            this.m_mainWindow.print("PIV objects read scenario aborted!", MainWindow.LogType.ScenarioBoundary);
            return;
        }
        if (!this.getSelectedObject()) {
            this.postamble(false);
            this.m_mainWindow.print("PIV objects read scenario aborted!", MainWindow.LogType.ScenarioBoundary);
            return;
        }
        if (this.m_listPINNeed[this.m_selectedObject] && !this.logIntoCardApplication()) {
            this.postamble(false);
            this.m_mainWindow.print("PIV objects read scenario aborted!", MainWindow.LogType.ScenarioBoundary);
            return;
        }
        this.readObject();
        this.postamble(this.m_listPINNeed[this.m_selectedObject]);
        this.m_mainWindow.print("PIV objects read scenario completed.", MainWindow.LogType.ScenarioBoundary);
    }

    public void postamble(boolean bl) {
        if (bl) {
            this.logoutOfCardApplication();
        }
        this.disconnect();
    }

    public boolean preamble() {
        this.listReaders();
        if (this.m_readerList == null || this.m_readerList.length == 0) {
            this.m_mainWindow.print("No card reader detected.");
            return false;
        }
        int n = this.m_mainWindow.showSelectionDialog("Select the reader", this.m_readerList);
        return n != -1 && this.connect(this.m_readerList[n]) && this.selectCardApplication();
    }

    public boolean getSelectedCertificate() {
        this.listCertificates();
        if (this.m_cardCertsCnt == 0) {
            this.m_mainWindow.print("No certificate found on the card.");
            return false;
        }
        this.m_certOnCurrentCardLabelsList = new String[this.m_cardCertsCnt];
        this.m_certOnCurrentCardOIDsList = new String[this.m_cardCertsCnt];
        int[] nArray = new int[this.m_cardCertsCnt];
        int n = 0;
        for (int i = 0; i < this.m_nbCertificates; ++i) {
            if (!this.m_certPresence[i]) continue;
            this.m_certOnCurrentCardLabelsList[n] = this.m_listLabels[this.m_certIndexList[i]];
            this.m_certOnCurrentCardOIDsList[n] = this.m_listOIDs[this.m_certIndexList[i]];
            nArray[n] = i;
            ++n;
        }
        int n2 = this.m_mainWindow.showSelectionDialog("Select the certificate", this.m_certOnCurrentCardLabelsList);
        if (n2 == -1) {
            return false;
        }
        this.m_selectedObject = nArray[n2];
        return true;
    }

    public boolean getSelectedObject() {
        this.listObjects();
        if (this.m_cardObjCnt == 0) {
            this.m_mainWindow.print("No object found on the card.");
            return false;
        }
        this.m_objOnCurrentCardLabelsList = new String[this.m_cardObjCnt];
        this.m_objOnCurrentCardOIDsList = new String[this.m_cardObjCnt];
        int[] nArray = new int[this.m_cardObjCnt];
        int n = 0;
        for (int i = 0; i < this.m_nbObjects; ++i) {
            if (!this.m_objPresence[i]) continue;
            this.m_objOnCurrentCardLabelsList[n] = this.m_listLabels[i];
            this.m_objOnCurrentCardOIDsList[n] = this.m_listOIDs[i];
            nArray[n] = i;
            ++n;
        }
        int n2 = this.m_mainWindow.showSelectionDialog("Select the object", this.m_objOnCurrentCardLabelsList);
        if (n2 == -1) {
            return false;
        }
        this.m_selectedObject = nArray[n2];
        return true;
    }

    public void readObject() {
        byte[] byArray;
        String string = this.m_listOIDs[this.m_selectedObject];
        try {
            byArray = this.myPivApi.pivGetData(this.m_hCard, string);
        }
        catch (PIVAPIException pIVAPIException) {
            this.m_mainWindow.print("pivGetData failed with error " + this.myPivApi.getStringErrorCode(pIVAPIException.getErrorCode()), MainWindow.LogType.APIError);
            if (this.m_listPINNeed[this.m_selectedObject]) {
                this.logoutOfCardApplication();
            }
            return;
        }
        String string2 = Helper.byteArrayToASCIIString(byArray);
        this.m_mainWindow.print(this.m_listLabels[this.m_selectedObject] + " = ");
        this.m_mainWindow.print(string2, MainWindow.LogType.APIInfo);
    }

    public void listReaders() {
        int n;
        byte[] byArray = new byte[1000];
        byArray[0] = 127;
        byArray[1] = 33;
        byArray[2] = 4;
        byArray[3] = -127;
        byArray[4] = 0;
        byArray[5] = -112;
        byArray[6] = 0;
        try {
            this.myPivApi.pivConnect(true, byArray);
        }
        catch (PIVAPIException pIVAPIException) {
            this.m_mainWindow.print("pivConnect failed with error " + this.myPivApi.getStringErrorCode(pIVAPIException.getErrorCode()), MainWindow.LogType.APIError);
            return;
        }
        String string = new String();
        int n2 = 0;
        for (n = 0; n < byArray.length; ++n) {
            if ((char)byArray[n] != '\u0000') {
                string = string + (char)byArray[n];
                continue;
            }
            if (string.length() == 0) break;
            string = new String();
            ++n2;
        }
        if (n2 > 0) {
            n = 0;
            this.m_readerList = new String[n2];
            string = new String();
            for (int i = 0; i < byArray.length; ++i) {
                if ((char)byArray[i] != '\u0000') {
                    string = string + (char)byArray[i];
                    continue;
                }
                if (string.length() == 0) break;
                this.m_readerList[n] = string;
                ++n;
                string = new String();
            }
        }
    }

    public boolean connect(String string) {
        int n = 7 + string.length();
        byte[] byArray = new byte[n];
        byArray[0] = 127;
        byArray[1] = 33;
        byArray[2] = (byte)(n - 3);
        byArray[3] = -127;
        byArray[4] = (byte)string.length();
        for (int i = 0; i < string.length(); ++i) {
            byArray[5 + i] = (byte)string.charAt(i);
        }
        byArray[n - 2] = -112;
        byArray[n - 1] = 0;
        try {
            this.m_hCard = this.myPivApi.pivConnect(true, byArray);
        }
        catch (PIVAPIException pIVAPIException) {
            this.m_mainWindow.print("pivConnect failed with error " + this.myPivApi.getStringErrorCode(pIVAPIException.getErrorCode()), MainWindow.LogType.APIError);
            return false;
        }
        return true;
    }

    public void logoutOfCardApplication() {
        if (this.m_hCard == -1L) {
            this.m_mainWindow.print("Invalid card handle", MainWindow.LogType.ScenarioError);
            return;
        }
        try {
            this.myPivApi.pivLogoutOfCardApplication(this.m_hCard);
        }
        catch (PIVAPIException pIVAPIException) {
            this.m_mainWindow.print("pivLogoutOfCardApplication failed with error " + this.myPivApi.getStringErrorCode(pIVAPIException.getErrorCode()), MainWindow.LogType.APIError);
        }
    }

    public void disconnect() {
        if (this.m_hCard == -1L) {
            this.m_mainWindow.print("Invalid card handle", MainWindow.LogType.ScenarioError);
            return;
        }
        try {
            this.myPivApi.pivDisconnect(this.m_hCard);
            this.m_hCard = -1L;
        }
        catch (PIVAPIException pIVAPIException) {
            this.m_mainWindow.print("pivDisconnect failed with error " + this.myPivApi.getStringErrorCode(pIVAPIException.getErrorCode()), MainWindow.LogType.APIError);
        }
    }

    public void signData(byte by, byte by2) {
        byte[] byArray;
        int n;
        if (this.m_hCard == -1L) {
            this.m_mainWindow.print("Invalid card handle", MainWindow.LogType.ScenarioError);
            return;
        }
        int n2 = 0;
        switch (by2) {
            case 0: 
            case 6: {
                n2 = 128;
                break;
            }
            case 7: {
                n2 = 256;
                break;
            }
            case 5: {
                n2 = 384;
            }
        }
        if (n2 == 0) {
            this.m_mainWindow.print("Invalid algorithmIdentifier", MainWindow.LogType.ScenarioError);
            return;
        }
        int n3 = this.m_dataToSign.length;
        byte[] byArray2 = new byte[n2];
        byArray2[0] = 0;
        byArray2[1] = 1;
        for (n = 2; n < n2 - 1 - n3; ++n) {
            byArray2[n] = -1;
        }
        byArray2[n2 - n3 - 1] = 0;
        for (n = 0; n < n3; ++n) {
            byArray2[n + n2 - n3] = this.m_dataToSign[n];
        }
        n = n2;
        if (n2 + 4 <= 127) {
            n += 6;
        } else if (n2 + 4 > 127 && n2 + 5 < 256) {
            n += 8;
        } else if (n2 + 5 >= 256) {
            n += 10;
        }
        byte[] byArray3 = new byte[n];
        byArray3[0] = 124;
        if (n2 + 4 <= 127) {
            byArray3[1] = (byte)(n2 + 4);
            byArray3[2] = -126;
            byArray3[3] = 0;
            byArray3[4] = -127;
            byArray3[5] = (byte)n2;
            Helper.copyArrays(byArray3, 6, byArray2);
        } else if (n2 + 4 > 127 && n2 + 5 < 256) {
            byArray3[1] = -127;
            byArray3[2] = (byte)(n2 + 5);
            byArray3[3] = -126;
            byArray3[4] = 0;
            byArray3[5] = -127;
            byArray3[6] = -127;
            byArray3[7] = (byte)n2;
            Helper.copyArrays(byArray3, 8, byArray2);
        } else if (n2 + 5 >= 256) {
            byArray3[1] = -126;
            byArray3[2] = (byte)((n2 + 6 & 0xFF00) >> 8);
            byArray3[3] = (byte)(n2 + 6 & 0xFF);
            byArray3[4] = -126;
            byArray3[5] = 0;
            byArray3[6] = -127;
            byArray3[7] = -126;
            byArray3[8] = (byte)((n2 & 0xFF00) >> 8);
            byArray3[9] = (byte)(n2 & 0xFF);
            Helper.copyArrays(byArray3, 10, byArray2);
        }
        try {
            byArray = this.myPivApi.pivCrypt(this.m_hCard, by2, by, byArray3);
        }
        catch (PIVAPIException pIVAPIException) {
            this.m_mainWindow.print("pivCrypt failed with error " + this.myPivApi.getStringErrorCode(pIVAPIException.getErrorCode()), MainWindow.LogType.APIError);
            return;
        }
        this.m_mainWindow.print("signed data:");
        this.m_mainWindow.print(Helper.byteArrayToASCIIString(byArray), MainWindow.LogType.APIInfo);
    }

    public void listCertificates() {
        if (this.m_hCard == -1L) {
            this.m_mainWindow.print("Invalid card handle", MainWindow.LogType.ScenarioError);
            return;
        }
        this.m_cardCertsCnt = 0;
        for (int i = 0; i < this.m_nbCertificates; ++i) {
            String string = this.m_listOIDs[this.m_certIndexList[i]];
            try {
                if (this.myPivApi.pivGetData(this.m_hCard, string).length <= 0) continue;
                this.m_certPresence[i] = true;
                ++this.m_cardCertsCnt;
                continue;
            }
            catch (PIVAPIException pIVAPIException) {
                this.m_certPresence[i] = false;
                if (pIVAPIException.getErrorCode() != 11) continue;
                this.m_certPresence[i] = true;
                ++this.m_cardCertsCnt;
            }
        }
    }

    public void listObjects() {
        if (this.m_hCard == -1L) {
            this.m_mainWindow.print("Invalid card handle", MainWindow.LogType.ScenarioError);
            return;
        }
        this.m_cardObjCnt = 0;
        for (int i = 0; i < this.m_nbObjects; ++i) {
            String string = this.m_listOIDs[i];
            try {
                if (this.myPivApi.pivGetData(this.m_hCard, string).length > 0) {
                    this.m_objPresence[i] = true;
                    ++this.m_cardObjCnt;
                    continue;
                }
                this.m_objPresence[i] = false;
                continue;
            }
            catch (PIVAPIException pIVAPIException) {
                this.m_objPresence[i] = false;
                if (pIVAPIException.getErrorCode() != 11) continue;
                this.m_objPresence[i] = true;
                ++this.m_cardObjCnt;
            }
        }
    }

    public boolean selectCardApplication() {
        if (this.m_hCard == -1L) {
            this.m_mainWindow.print("Invalid card handle", MainWindow.LogType.ScenarioError);
            return false;
        }
        String string = "A00000030800001000";
        byte[] byArray = Helper.ConvAsciiToBin(string);
        try {
            this.myPivApi.pivSelectCardApplication(this.m_hCard, byArray);
        }
        catch (PIVAPIException pIVAPIException) {
            this.m_mainWindow.print("pivSelectCardApplication failed with error " + this.myPivApi.getStringErrorCode(pIVAPIException.getErrorCode()), MainWindow.LogType.APIError);
            return false;
        }
        return true;
    }

    public boolean logIntoCardApplication() {
        if (this.m_hCard == -1L) {
            this.m_mainWindow.print("Invalid card handle", MainWindow.LogType.ScenarioError);
            return false;
        }
        String string = this.m_mainWindow.showPINDialog();
        if (string == null) {
            return false;
        }
        int n = 5 + string.length() + 3;
        byte[] byArray = new byte[n];
        byArray[0] = 103;
        byArray[1] = -127;
        byArray[2] = (byte)(n - 3);
        byArray[3] = -125;
        byArray[4] = 1;
        byArray[5] = -128;
        byArray[6] = -127;
        byArray[7] = (byte)string.length();
        for (int i = 0; i < string.length(); ++i) {
            byArray[8 + i] = (byte)string.charAt(i);
        }
        try {
            this.myPivApi.pivLogIntoCardApplication(this.m_hCard, byArray);
        }
        catch (PIVAPIException pIVAPIException) {
            this.m_mainWindow.print("pivLogIntoCardApplication failed with error " + this.myPivApi.getStringErrorCode(pIVAPIException.getErrorCode()), MainWindow.LogType.APIError);
            return false;
        }
        return true;
    }

    @Override
    public void runScenario(int n) {
        switch (n) {
            case 0: {
                this.pivSignature();
                break;
            }
            case 1: {
                this.pivObjectsRead();
                break;
            }
            default: {
                this.m_mainWindow.print("Combo box state corrupt", MainWindow.LogType.ScenarioError);
            }
        }
    }
}

