/*
 * Decompiled with CFR 0.152.
 */
package bsi;

import bsi.Helper;
import gov.gsc.classes.BSIAuthenticator;
import gov.gsc.classes.BSIException;
import gov.gsc.classes.ContainerProperties;
import gov.gsc.classes.CryptoProperties;
import gov.gsc.classes.GSCBSI;
import java.util.Arrays;
import java.util.Vector;
import ui.MainWindow;
import ui.ScenarioInterface;

public class Scenarios
implements ScenarioInterface {
    private int m_hCard = -1;
    private String[] m_readerList = null;
    private MainWindow m_mainWindow = new MainWindow(this, new String[]{"Data signature", "Data items read", "APDUs sending"}, "HID Global BSI API Java sample");
    public GSCBSI m_bsi = null;

    public Scenarios() {
        try {
            this.m_bsi = new GSCBSI();
            if (this.m_bsi == null) {
                this.m_mainWindow.print("Failed to initialize BSI API", MainWindow.LogType.ScenarioError);
            } else {
                this.m_mainWindow.print("------------------------------------------------------------------------------------");
                this.m_mainWindow.print("HID Global BSI API Java Sample");
                this.m_mainWindow.print("Copyright \u00a9 2016 HID Global Corporation/ASSA ABLOY AB. All rights reserved.");
                this.m_mainWindow.print("------------------------------------------------------------------------------------");
            }
        }
        catch (Exception exception) {
            this.m_mainWindow.print("BSI Exception : " + exception.toString(), MainWindow.LogType.ScenarioError);
            System.exit(-1);
        }
        String string = null;
        try {
            string = this.m_bsi.gscBsiUtilGetVersion();
        }
        catch (Exception exception) {
            this.m_mainWindow.print("BSI Exception : " + exception.toString(), MainWindow.LogType.ScenarioError);
            System.exit(-1);
        }
        String string2 = "This sample demonstrates how to use the BSI API version 2.1 (\"" + string + "\") provided by ActivClient 7.1 from a Java program.\n" + "It implements following scenarios:\n" + "        -    How to use a private key to sign some data.\n" + "        -    How to read data items from the card.\n" + "        -    How to send APDUs to an applet instance.\n";
        this.m_mainWindow.showMessageDialog(string2);
    }

    public void scenarioSignData() {
        String string = "";
        String string2 = "";
        reftype reftype2 = new reftype();
        reftype2.typeAuth = 0;
        reftype2.keylen = -1;
        boolean bl = false;
        this.m_mainWindow.print("Starting Data Sign scenario.", MainWindow.LogType.ScenarioBoundary);
        this.m_mainWindow.print("Try connecting to reader ...", MainWindow.LogType.ScenarioInfo);
        if (!this.preamble()) {
            this.m_mainWindow.print("End of Data Sign scenario.", MainWindow.LogType.ScenarioBoundary);
            return;
        }
        string = this.m_mainWindow.showAIDDialog("Enter PKI Applet ID:");
        this.m_mainWindow.print("pki AID: " + string);
        if (string == null) {
            this.m_mainWindow.print("Operation (PKI AID) canceled");
            this.m_mainWindow.print("End of Data Sign scenario.", MainWindow.LogType.ScenarioBoundary);
            return;
        }
        if (!this.getPKIContainerAccessRules(string, reftype2)) {
            this.m_mainWindow.print("End of Data Sign scenario.", MainWindow.LogType.ScenarioBoundary);
            return;
        }
        int n = reftype2.keylen;
        if (reftype2.typeAuth == 6) {
            string2 = this.m_mainWindow.showAIDDialog("Enter PIN Applet ID:");
            if (string2 == null) {
                this.m_mainWindow.print("Operation (Pin AID) canceled");
                this.m_mainWindow.print("End of Data Sign scenario.", MainWindow.LogType.ScenarioBoundary);
                return;
            }
            if (!this.logIntoCardApplication(string2)) {
                this.m_mainWindow.print("End of Data Sign scenario.", MainWindow.LogType.ScenarioBoundary);
                return;
            }
            bl = true;
        }
        String string3 = "3020300c06082a864886f70d020505000410818c6e601a24f72750da0f6c9b8ebe28";
        byte[] byArray = new byte[n];
        Arrays.fill(byArray, (byte)-1);
        byArray[0] = 0;
        byArray[1] = 1;
        System.arraycopy(string3.getBytes(), 0, byArray, byArray.length - string3.length(), string3.length());
        String string4 = Helper.bytesToHex(byArray);
        this.m_mainWindow.print("data to be signed (hex): " + Helper.byteArrayToASCIIString(string4.getBytes()), MainWindow.LogType.APIInfo);
        byte[] byArray2 = new byte[string4.length()];
        System.arraycopy(string4.getBytes(), 0, byArray2, 0, string4.length());
        short s = 163;
        byte[] byArray3 = null;
        try {
            byArray3 = this.m_bsi.gscBsiPkiCompute(this.m_hCard, string, s, byArray2);
            this.m_mainWindow.print("Data signature succeeded.");
            this.m_mainWindow.print("signature (hex): " + Helper.byteArrayToASCIIString(byArray3), MainWindow.LogType.APIInfo);
        }
        catch (Exception exception) {
            this.m_mainWindow.print(exception.toString(), MainWindow.LogType.APIError);
            this.m_mainWindow.print(this.gscBsiUtilGetExtendedErrorText(), MainWindow.LogType.APIError);
            this.m_mainWindow.print("End of Data Sign scenario.", MainWindow.LogType.ScenarioBoundary);
            return;
        }
        this.postamble(bl, string2);
        this.m_mainWindow.print("End of Data Sign scenario.", MainWindow.LogType.ScenarioBoundary);
    }

    public void scenarioReadDataItems() {
        String string = "";
        String string2 = "";
        boolean bl = false;
        reftype reftype2 = new reftype();
        reftype2.typeAuth = 0;
        reftype2.keylen = -1;
        this.m_mainWindow.print("Starting Read Data Items scenario.", MainWindow.LogType.ScenarioBoundary);
        this.m_mainWindow.print("Try connecting to reader ...", MainWindow.LogType.APIInfo);
        if (!this.preamble()) {
            this.m_mainWindow.print("End of Read Data Items scenario.", MainWindow.LogType.ScenarioBoundary);
            return;
        }
        this.m_mainWindow.print("m_hCard: " + this.m_hCard);
        string = this.m_mainWindow.showAIDDialog("Enter GC Applet ID:");
        this.m_mainWindow.print("GC AID: " + string);
        if (string == null) {
            this.m_mainWindow.print("Operation (GC AID) canceled");
            this.m_mainWindow.print("End of Read Data Items scenario.", MainWindow.LogType.ScenarioBoundary);
            return;
        }
        if (!this.getGCContainerAccessRules(string, reftype2)) {
            this.m_mainWindow.print("End of Read Data Items scenario.", MainWindow.LogType.ScenarioBoundary);
            return;
        }
        if (reftype2.typeAuth == 6) {
            string2 = this.m_mainWindow.showAIDDialog("Enter PIN Applet ID:");
            if (string2 == null) {
                this.m_mainWindow.print("Operation (Pin AID) canceled");
                this.m_mainWindow.print("End of Read Data Items scenario.", MainWindow.LogType.ScenarioBoundary);
                return;
            }
            if (!this.logIntoCardApplication(string2)) {
                this.m_mainWindow.print("End of Read Data Items scenario.", MainWindow.LogType.ScenarioBoundary);
                return;
            }
            bl = true;
        }
        this.m_mainWindow.print("Reading applet's tags ...");
        short[] sArray = null;
        try {
            sArray = this.m_bsi.gscBsiGcReadTagList(this.m_hCard, string);
        }
        catch (BSIException bSIException) {
            this.m_mainWindow.print("BSI Exception: " + bSIException.toString(), MainWindow.LogType.APIInfo);
            this.m_mainWindow.print(this.gscBsiUtilGetExtendedErrorText(), MainWindow.LogType.APIError);
            this.m_mainWindow.print("End of Read Data Items scenario.", MainWindow.LogType.ScenarioBoundary);
            return;
        }
        if (sArray == null) {
            this.m_mainWindow.print("No tags found.");
        } else {
            this.m_mainWindow.print("Found " + sArray.length + " tags");
        }
        this.m_mainWindow.print("Reading tag values:");
        for (int i = 0; i < sArray.length; ++i) {
            byte[] byArray = null;
            try {
                byArray = this.m_bsi.gscBsiGcReadValue(this.m_hCard, string, sArray[i]);
            }
            catch (BSIException bSIException) {
                this.m_mainWindow.print("Exception: " + bSIException.toString(), MainWindow.LogType.APIInfo);
                this.m_mainWindow.print(this.gscBsiUtilGetExtendedErrorText(), MainWindow.LogType.APIError);
                this.m_mainWindow.print("End of Read Data Items scenario.", MainWindow.LogType.ScenarioBoundary);
                return;
            }
            this.m_mainWindow.print("tag # " + i + " = " + sArray[i]);
            this.m_mainWindow.print("Value =" + Helper.byteArrayToASCIIString(byArray));
        }
        this.postamble(bl, string2);
        this.m_mainWindow.print("End of Read Data Items scenario.", MainWindow.LogType.ScenarioBoundary);
    }

    public void scenarioSendAPDUs() {
        String string = "";
        boolean bl = false;
        this.m_mainWindow.print("Starting Send APDUs scenario.", MainWindow.LogType.ScenarioBoundary);
        this.m_mainWindow.print("Try connecting to reader ...", MainWindow.LogType.APIInfo);
        if (!this.preamble()) {
            this.m_mainWindow.print("End of Send APDUs scenario.", MainWindow.LogType.ScenarioBoundary);
            return;
        }
        this.m_mainWindow.print("m_hCard: " + this.m_hCard);
        string = this.m_mainWindow.showAIDDialog("Enter PIN Applet ID:");
        this.m_mainWindow.print("PIN applet AID: " + string);
        if (string == null) {
            this.m_mainWindow.print("Operation (PIN AID) canceled");
            this.m_mainWindow.print("End of Send APDUs scenario.", MainWindow.LogType.ScenarioBoundary);
            return;
        }
        if (!this.gscXsiNotifySynchronizationStart()) {
            this.m_mainWindow.print("End of Send APDUs scenario.", MainWindow.LogType.ScenarioBoundary);
            return;
        }
        if (!this.bsiUtilBeginTransaction()) {
            this.m_mainWindow.print("End of Send APDUs scenario.", MainWindow.LogType.ScenarioBoundary);
            return;
        }
        if (!this.sendAPDUSelectApplet(string)) {
            this.m_mainWindow.print("End of Send APDUs scenario.", MainWindow.LogType.ScenarioBoundary);
            return;
        }
        if (!this.sendAPDUPINVerified()) {
            this.m_mainWindow.print("End of Send APDUs scenario.", MainWindow.LogType.ScenarioBoundary);
            return;
        }
        if (!this.bsiUtilEndTransaction()) {
            this.m_mainWindow.print("End of Send APDUs scenario.", MainWindow.LogType.ScenarioBoundary);
            return;
        }
        if (!this.gscXsiNotifySynchronizationEnd()) {
            this.m_mainWindow.print("End of Send APDUs scenario.", MainWindow.LogType.ScenarioBoundary);
            return;
        }
        this.postamble(bl, string);
        this.m_mainWindow.print("End of Send APDUs scenario.", MainWindow.LogType.ScenarioBoundary);
    }

    public boolean bsiUtilBeginTransaction() {
        boolean bl = true;
        boolean bl2 = true;
        try {
            if (this.m_hCard != -1) {
                this.m_bsi.gscBsiUtilBeginTransaction(this.m_hCard, bl2);
                this.m_mainWindow.print("Started BSI transaction");
            } else {
                this.m_mainWindow.print("No BSIConnection", MainWindow.LogType.ScenarioError);
                bl = false;
            }
        }
        catch (Exception exception) {
            this.m_mainWindow.print("BSI Exception : " + exception.toString(), MainWindow.LogType.APIError);
            this.m_mainWindow.print(this.gscBsiUtilGetExtendedErrorText(), MainWindow.LogType.APIError);
            bl = false;
        }
        return bl;
    }

    public boolean bsiUtilEndTransaction() {
        boolean bl = true;
        try {
            if (this.m_hCard != -1) {
                this.m_bsi.gscBsiUtilEndTransaction(this.m_hCard);
                this.m_mainWindow.print("Ended BSI transaction");
            } else {
                this.m_mainWindow.print("No BSIConnection", MainWindow.LogType.ScenarioError);
                bl = false;
            }
        }
        catch (Exception exception) {
            this.m_mainWindow.print("BSI Exception : " + exception.toString(), MainWindow.LogType.APIError);
            this.m_mainWindow.print(this.gscBsiUtilGetExtendedErrorText(), MainWindow.LogType.APIError);
            bl = false;
        }
        return bl;
    }

    public boolean gscXsiNotifySynchronizationStart() {
        boolean bl = true;
        try {
            if (this.m_hCard != -1) {
                this.m_bsi.gscXsiNotifySynchronizationStart(this.m_hCard);
                this.m_mainWindow.print("Started BSI Notify Synchronization");
            } else {
                this.m_mainWindow.print("No BSIConnection", MainWindow.LogType.ScenarioError);
                bl = false;
            }
        }
        catch (Exception exception) {
            this.m_mainWindow.print("BSI Exception : " + exception.toString(), MainWindow.LogType.APIError);
            this.m_mainWindow.print(this.gscBsiUtilGetExtendedErrorText(), MainWindow.LogType.APIError);
            bl = false;
        }
        return bl;
    }

    public boolean gscXsiNotifySynchronizationEnd() {
        boolean bl = false;
        try {
            if (this.m_hCard != -1) {
                this.m_bsi.gscXsiNotifySynchronizationEnd(this.m_hCard);
                this.m_mainWindow.print("Ended BSI Notify Synchronization");
            } else {
                this.m_mainWindow.print("No BSIConnection", MainWindow.LogType.ScenarioError);
                bl = false;
            }
        }
        catch (Exception exception) {
            this.m_mainWindow.print("BSI Exception : " + exception.toString(), MainWindow.LogType.APIError);
            this.m_mainWindow.print(this.gscBsiUtilGetExtendedErrorText(), MainWindow.LogType.APIError);
            bl = false;
        }
        return bl;
    }

    public boolean sendAPDUSelectApplet(String string) {
        boolean bl = true;
        try {
            String string2;
            if (this.m_hCard == -1) {
                this.m_mainWindow.print("No BSIConnection", MainWindow.LogType.ScenarioError);
                return false;
            }
            String string3 = string2 = "00A4040007" + string;
            this.m_mainWindow.print("Send Select Applet APDU = " + string3);
            byte[] byArray = this.m_bsi.gscBsiUtilPassthru(this.m_hCard, string3.getBytes());
            this.m_mainWindow.print("Select Applet APDU sent successfully");
            this.m_mainWindow.print("Response = " + Helper.byteArrayToASCIIString(byArray));
        }
        catch (Exception exception) {
            this.m_mainWindow.print("BSI Exception : " + exception.toString(), MainWindow.LogType.APIError);
            this.m_mainWindow.print(this.gscBsiUtilGetExtendedErrorText(), MainWindow.LogType.APIError);
            bl = false;
        }
        return bl;
    }

    public boolean sendAPDUPINVerified() {
        boolean bl = true;
        try {
            if (this.m_hCard != -1) {
                String string;
                String string2 = string = "8020000000";
                this.m_mainWindow.print("Send PIN Verified APDU=" + string2);
                byte[] byArray = this.m_bsi.gscBsiUtilPassthru(this.m_hCard, string2.getBytes());
                this.m_mainWindow.print("IsPINVerified APDU sent successfully");
                this.m_mainWindow.print("Response = " + Helper.byteArrayToASCIIString(byArray));
            } else {
                this.m_mainWindow.print("No BSIConnection", MainWindow.LogType.ScenarioError);
                bl = false;
            }
        }
        catch (Exception exception) {
            this.m_mainWindow.print("BSI Exception : " + exception.toString(), MainWindow.LogType.APIError);
            this.m_mainWindow.print(this.gscBsiUtilGetExtendedErrorText(), MainWindow.LogType.APIError);
            bl = false;
        }
        return bl;
    }

    public void postamble(boolean bl, String string) {
        if (bl) {
            this.logoutOfCardApplication(string);
        }
        this.disconnect();
    }

    public boolean preamble() {
        this.listReaders();
        if (this.m_readerList == null || this.m_readerList.length == 0) {
            this.m_mainWindow.print("No card reader detected.", MainWindow.LogType.APIInfo);
            return false;
        }
        int n = this.m_mainWindow.showSelectionDialog("Select the reader", this.m_readerList);
        return n != -1 && this.connect(this.m_readerList[n]);
    }

    public void listReaders() {
        try {
            Vector vector = this.m_bsi.gscBsiUtilGetReaderList();
            if (vector != null) {
                this.m_readerList = new String[vector.size()];
                for (int i = 0; i < vector.size(); ++i) {
                    this.m_readerList[i] = (String)vector.elementAt(i);
                }
            }
        }
        catch (Exception exception) {
            this.m_mainWindow.print("BSI Exception : " + exception.toString(), MainWindow.LogType.APIError);
            this.m_mainWindow.print(this.gscBsiUtilGetExtendedErrorText(), MainWindow.LogType.APIError);
            return;
        }
    }

    public boolean connect(String string) {
        this.m_mainWindow.print("Connect to reader: " + string);
        try {
            this.m_hCard = this.m_bsi.gscBsiUtilConnect(string);
            if (this.m_hCard == -1) {
                this.m_mainWindow.print("Failed to connect to card.", MainWindow.LogType.APIError);
                return false;
            }
            this.m_mainWindow.print("Connection to reader succeeded");
        }
        catch (Exception exception) {
            this.m_mainWindow.print("BSI Exception : " + exception.toString(), MainWindow.LogType.APIError);
            this.m_mainWindow.print(this.gscBsiUtilGetExtendedErrorText(), MainWindow.LogType.APIError);
            return false;
        }
        return true;
    }

    public void logoutOfCardApplication(String string) {
        if (this.m_hCard == -1) {
            this.m_mainWindow.print("Invalid card handle", MainWindow.LogType.ScenarioError);
            return;
        }
        try {
            this.m_bsi.gscBsiUtilReleaseContext(this.m_hCard, string);
            this.m_mainWindow.print("Logout succeeded");
        }
        catch (Exception exception) {
            this.m_mainWindow.print("BSI Exception : " + exception.toString(), MainWindow.LogType.APIError);
            this.m_mainWindow.print(this.gscBsiUtilGetExtendedErrorText(), MainWindow.LogType.APIError);
        }
    }

    public void disconnect() {
        if (this.m_hCard == -1) {
            this.m_mainWindow.print("Invalid card handle", MainWindow.LogType.ScenarioError);
            return;
        }
        try {
            this.m_bsi.gscBsiUtilDisconnect(this.m_hCard);
            this.m_hCard = -1;
            this.m_mainWindow.print("Disconnected from reader");
        }
        catch (Exception exception) {
            this.m_mainWindow.print("BSI Exception : " + exception.toString(), MainWindow.LogType.APIError);
            this.m_mainWindow.print(this.gscBsiUtilGetExtendedErrorText(), MainWindow.LogType.APIError);
        }
    }

    public boolean logIntoCardApplication(String string) {
        Vector<BSIAuthenticator> vector = new Vector<BSIAuthenticator>();
        reftype reftype2 = new reftype();
        reftype2.typeAuth = 0;
        if (this.m_hCard == -1) {
            this.m_mainWindow.print("Invalid card handle", MainWindow.LogType.ScenarioError);
            return false;
        }
        String string2 = this.m_mainWindow.showPINDialog();
        if (string2 == null) {
            this.m_mainWindow.print("Operation (PIN) canceled", MainWindow.LogType.ScenarioError);
            return false;
        }
        try {
            String string3 = Helper.bytesToHex(string2.getBytes());
            this.m_mainWindow.print("Pin code in hex: " + string3);
            BSIAuthenticator bSIAuthenticator = new BSIAuthenticator(6, 1, string3.getBytes());
            vector.add(bSIAuthenticator);
            this.m_bsi.gscBsiUtilAcquireContext(this.m_hCard, string, vector);
        }
        catch (Exception exception) {
            this.m_mainWindow.print("BSI Exception : " + exception.toString(), MainWindow.LogType.APIError);
            this.m_mainWindow.print(this.gscBsiUtilGetExtendedErrorText(), MainWindow.LogType.APIError);
            return false;
        }
        this.m_mainWindow.print("Login succeeded");
        return true;
    }

    public boolean getPKIContainerAccessRules(String string, reftype reftype2) {
        boolean bl = true;
        try {
            if (this.m_hCard != -1) {
                this.m_mainWindow.print("Reading PKI Applet ACRs ...");
                CryptoProperties cryptoProperties = this.m_bsi.gscBsiGetCryptoProperties(this.m_hCard, string);
                this.m_mainWindow.print("RSA Key length   = " + cryptoProperties.getKeyLen());
                reftype2.keylen = cryptoProperties.getKeyLen();
                this.m_mainWindow.print("PKICompute ACR     = " + this.ACRtoString(cryptoProperties.getCRYPTOacr().getPkiComputeACR().getACRType()));
                if (cryptoProperties.getCRYPTOacr().getPkiComputeACR().getACRType() == 6 || cryptoProperties.getCRYPTOacr().getPkiComputeACR().getACRType() == 3 || cryptoProperties.getCRYPTOacr().getPkiComputeACR().getACRType() == 5) {
                    reftype2.typeAuth = 6;
                } else if (cryptoProperties.getCRYPTOacr().getPkiComputeACR().getACRType() != 0) {
                    this.m_mainWindow.print("Unsupported ACR for data signature", MainWindow.LogType.ScenarioError);
                    bl = false;
                }
            } else {
                this.m_mainWindow.print("No BSIConnection", MainWindow.LogType.ScenarioError);
                bl = false;
            }
        }
        catch (Exception exception) {
            this.m_mainWindow.print("BSI Exception : " + exception.toString(), MainWindow.LogType.APIError);
            this.m_mainWindow.print(this.gscBsiUtilGetExtendedErrorText(), MainWindow.LogType.APIError);
            bl = false;
        }
        return bl;
    }

    public String ACRtoString(int n) {
        switch (n) {
            case 0: {
                return "BSI_ACR_ALWAYS";
            }
            case 1: {
                return "BSI_ACR_NEVER";
            }
            case 2: {
                return "BSI_ACR_XAUTH";
            }
            case 3: {
                return "BSI_ACR_XAUTH_OR_PIN";
            }
            case 4: {
                return "BSI_SECURE_CHANNEL_GP";
            }
            case 5: {
                return "BSI_ACR_PIN_ALWAYS";
            }
            case 6: {
                return "BSI.BSI_ACR_PIN";
            }
            case 7: {
                return "BSI.BSI_ACR_XAUTH_THEN_PIN\t";
            }
            case 8: {
                return "BSI_ACR_UPDATE_ONCE";
            }
            case 9: {
                return "BSI_ACR_PIN_THEN_XAUTH";
            }
            case 11: {
                return "BSI_SECURE_CHANNEL_ISO";
            }
        }
        return "Unknow ACR";
    }

    public boolean getGCContainerAccessRules(String string, reftype reftype2) {
        boolean bl = true;
        try {
            if (this.m_hCard != -1) {
                this.m_mainWindow.print("Reading GC Applet ACRs ...");
                ContainerProperties containerProperties = this.m_bsi.gscBsiGcGetContainerProperties(this.m_hCard, string);
                this.m_mainWindow.print("Read Tag List ACR    = " + this.ACRtoString(containerProperties.getGCacr().getReadTagListACR().getACRType()));
                this.m_mainWindow.print("Read Tag Value ACR   = " + this.ACRtoString(containerProperties.getGCacr().getReadValueACR().getACRType()));
                if (containerProperties.getGCacr().getReadTagListACR().getACRType() == 6 || containerProperties.getGCacr().getReadTagListACR().getACRType() == 5 || containerProperties.getGCacr().getReadTagListACR().getACRType() == 3) {
                    reftype2.typeAuth = 6;
                } else if (containerProperties.getGCacr().getReadTagListACR().getACRType() != 0) {
                    this.m_mainWindow.print("Unsupported ACR for Read Tag List", MainWindow.LogType.ScenarioError);
                    bl = false;
                }
                if (containerProperties.getGCacr().getReadValueACR().getACRType() == 6 || containerProperties.getGCacr().getReadValueACR().getACRType() == 5 || containerProperties.getGCacr().getReadValueACR().getACRType() == 3) {
                    reftype2.typeAuth = 6;
                } else if (containerProperties.getGCacr().getReadValueACR().getACRType() != 0) {
                    this.m_mainWindow.print("Unsupported ACR for Read Tag Value", MainWindow.LogType.ScenarioError);
                    bl = false;
                }
            } else {
                this.m_mainWindow.print("No BSIConnection");
                bl = false;
            }
        }
        catch (Exception exception) {
            this.m_mainWindow.print("BSI Exception : " + exception.toString(), MainWindow.LogType.APIError);
            this.m_mainWindow.print(this.gscBsiUtilGetExtendedErrorText(), MainWindow.LogType.APIError);
            bl = false;
        }
        return bl;
    }

    public String gscBsiUtilGetExtendedErrorText() {
        String string = "";
        try {
            string = this.m_bsi.gscBsiUtilGetExtendedErrorText(this.m_hCard);
        }
        catch (Exception exception) {
            this.m_mainWindow.print("Exception : " + exception.toString(), MainWindow.LogType.APIError);
        }
        return string;
    }

    @Override
    public void runScenario(int n) {
        switch (n) {
            case 0: {
                this.scenarioSignData();
                break;
            }
            case 1: {
                this.scenarioReadDataItems();
                break;
            }
            case 2: {
                this.scenarioSendAPDUs();
                break;
            }
            default: {
                this.m_mainWindow.print("Combo box state corrupt", MainWindow.LogType.ScenarioError);
            }
        }
    }

    class reftype {
        public int typeAuth;
        public int keylen;

        reftype() {
        }
    }
}

