/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import ui.AIDDialog;
import ui.PINDialog;
import ui.ScenarioInterface;
import ui.SelectionDialog;

public class MainWindow
implements Runnable {
    private JFrame myFrame;
    private JComboBox<String> m_comboBox;
    private JTextPane m_textPane;
    private JButton m_executeButton;
    private JLabel m_scenarioLabel;
    private JButton m_clearButton;
    private JButton m_quitButton;
    private JScrollPane m_scrollPane;
    private String m_windowTitle;
    private int m_frameWidth = 600;
    private int m_frameHeight = 600;
    private ScenarioInterface m_scenarios;

    public MainWindow(ScenarioInterface scenarioInterface, String[] stringArray, String string) {
        this.m_scenarios = scenarioInterface;
        this.m_windowTitle = string;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            exception.printStackTrace();
        }
        this.m_textPane = new JTextPane();
        this.m_textPane.setContentType("text/html");
        this.m_comboBox = new JComboBox<String>(stringArray);
        SwingUtilities.invokeLater(this);
    }

    public void clearOutput() {
        this.m_textPane.setText("");
    }

    protected void setupUI() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 5;
        this.m_scrollPane = new JScrollPane(this.m_textPane);
        this.m_scrollPane.setHorizontalScrollBarPolicy(31);
        this.m_textPane.setEditable(false);
        this.m_textPane.setPreferredSize(new Dimension(100, 100));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(n, n, n, n);
        this.myFrame.add((Component)this.m_scenarioLabel, gridBagConstraints);
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(n, 0, n, n);
        this.myFrame.add(this.m_comboBox, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(n, 0, n, n);
        this.myFrame.add((Component)this.m_executeButton, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.insets = new Insets(0, n, n, n);
        this.myFrame.add((Component)this.m_scrollPane, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, n, n);
        this.myFrame.add((Component)this.m_clearButton, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, n, n);
        this.myFrame.add((Component)this.m_quitButton, gridBagConstraints);
        SymAction symAction = new SymAction();
        this.m_executeButton.addActionListener(symAction);
        this.m_clearButton.addActionListener(symAction);
        this.m_quitButton.addActionListener(symAction);
    }

    @Override
    public void run() {
        this.myFrame = new JFrame(this.m_windowTitle);
        this.m_executeButton = new JButton("Execute");
        this.m_scenarioLabel = new JLabel("Scenario:");
        this.m_clearButton = new JButton("Clear logs");
        this.m_quitButton = new JButton("Quit");
        this.myFrame.setLayout(new GridBagLayout());
        this.myFrame.setSize(this.m_frameWidth, this.m_frameHeight);
        this.myFrame.setMinimumSize(new Dimension(300, 300));
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n = dimension.height;
        int n2 = dimension.width;
        this.myFrame.setLocation((n2 - this.m_frameWidth) / 2, (n - this.m_frameHeight) / 3);
        SymWindow symWindow = new SymWindow();
        this.myFrame.addWindowListener(symWindow);
        this.setupUI();
        this.myFrame.setVisible(true);
    }

    public void print(String string) {
        this.print(string, LogType.Default);
    }

    public void print(String string, LogType logType) {
        System.out.println(string);
        Document document = this.m_textPane.getDocument();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        try {
            switch (logType) {
                case ScenarioBoundary: {
                    StyleConstants.setBold(simpleAttributeSet, true);
                    document.insertString(document.getLength(), string + "\n", simpleAttributeSet);
                    break;
                }
                case ScenarioError: {
                    StyleConstants.setForeground(simpleAttributeSet, new Color(127, 0, 0));
                    document.insertString(document.getLength(), string + "\n", simpleAttributeSet);
                    break;
                }
                case APIInfo: {
                    StyleConstants.setForeground(simpleAttributeSet, new Color(0, 127, 0));
                    document.insertString(document.getLength(), "\t" + string + "\n", simpleAttributeSet);
                    break;
                }
                case APIError: {
                    StyleConstants.setForeground(simpleAttributeSet, new Color(127, 0, 0));
                    document.insertString(document.getLength(), "\t" + string + "\n", simpleAttributeSet);
                    break;
                }
                default: {
                    document.insertString(document.getLength(), string + "\n", simpleAttributeSet);
                    break;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public int showSelectionDialog(String string, String[] stringArray) {
        SelectionDialog selectionDialog = new SelectionDialog(this.myFrame, string, stringArray);
        if (!selectionDialog.isOk() || selectionDialog.m_sSelection.length() == 0) {
            return -1;
        }
        return selectionDialog.m_selectionIdx;
    }

    public String showPINDialog() {
        PINDialog pINDialog = new PINDialog(this.myFrame, "Enter the PIN code", null);
        if (pINDialog.m_bCanceled) {
            return null;
        }
        return pINDialog.getString();
    }

    public void showMessageDialog(String string) {
        JOptionPane.showMessageDialog(this.myFrame, string, this.m_windowTitle, 1);
    }

    public String showAIDDialog(String string) {
        AIDDialog aIDDialog = new AIDDialog(this.myFrame, string, null);
        if (aIDDialog.m_bCanceled) {
            return null;
        }
        return aIDDialog.getString();
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == MainWindow.this.m_executeButton) {
                MainWindow.this.m_scenarios.runScenario(MainWindow.this.m_comboBox.getSelectedIndex());
            } else if (object == MainWindow.this.m_clearButton) {
                MainWindow.this.clearOutput();
            } else if (object == MainWindow.this.m_quitButton) {
                MainWindow.this.print("Exiting...");
                System.exit(0);
            }
        }
    }

    public static enum LogType {
        ScenarioBoundary,
        ScenarioInfo,
        ScenarioError,
        APIInfo,
        APIError,
        Default;

    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == MainWindow.this.myFrame) {
                MainWindow.this.myFrame.dispose();
            }
        }
    }
}

