/*
 * Decompiled with CFR 0.152.
 */
package pkcs;

import iaik.pkcs.pkcs11.wrapper.CK_ATTRIBUTE;
import iaik.pkcs.pkcs11.wrapper.CK_MECHANISM;
import iaik.pkcs.pkcs11.wrapper.CK_SLOT_INFO;
import iaik.pkcs.pkcs11.wrapper.CK_TOKEN_INFO;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Connector;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import pkcs.Helper;
import ui.MainWindow;
import ui.ScenarioInterface;

public class Scenarios
implements ScenarioInterface {
    public static String hidProductName = "ActivClient";
    public static String hidCopyrightYear = "2019";
    private byte[] m_dataToSign;
    private byte[] m_signedData;
    private byte[] m_unlockCode;
    private PKCS11 m_pkcsInst;
    private String m_sPkcsSP = "acpkcs211.dll";
    private String m_sPkcsWrapper = "C:\\Program Files\\HID Global\\ActivClient\\pkcs11wrapper.dll";
    private byte[] m_dataToEncrypt = new byte[]{1, 2, 3, 4};
    private long m_sessionHandle;
    private long m_unlockObjHandle;
    private long m_privateKeyHandle;
    private long m_publicKeyHandle;
    private long m_secretKeyHandle;
    private long m_otpKeyHandle;
    private final String m_secretKeyLabel = "label";
    private byte[] m_encryptedData;
    private String[] m_readerList = null;
    private String[] m_certList = null;
    private long[] m_slotsIDList = null;
    private long m_selectedSlot = 0L;
    private long m_selectedCertificate = 0L;
    private long[] m_certHandleList = null;
    private byte[] m_selectedCertID = null;
    private boolean m_privateKeyIsPINAlways;
    private boolean m_cardCanBeUnblocked;
    private CK_TOKEN_INFO m_tokenInfo = null;
    private CK_MECHANISM m_mechanism = null;
    private MainWindow m_mainWindow;
    private boolean useUtf8 = true;

    public Scenarios() {
        Object object;
        try {
            this.m_dataToSign = "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.".getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.m_dataToSign = null;
            unsupportedEncodingException.printStackTrace();
            System.exit(-1);
        }
        this.m_mainWindow = new MainWindow(this, new String[]{"Data signature", "Login", "Secret key usage", "OTP generation"}, "HID Global PKCS API Java sample for IAIK");
        this.m_mainWindow.print("------------------------------------------------------------------------------------");
        this.m_mainWindow.print("HID Global PKCS#11 API Java Sample for IAIK");
        this.m_mainWindow.print("Copyright \u00a9 " + hidCopyrightYear + " HID Global Corporation/ASSA ABLOY AB. All rights reserved.");
        this.m_mainWindow.print("------------------------------------------------------------------------------------");
        try {
            this.m_pkcsInst = PKCS11Connector.connectToPKCS11Module((String)this.m_sPkcsSP, (String)this.m_sPkcsWrapper);
            this.m_pkcsInst.C_Initialize(null, this.useUtf8);
        }
        catch (PKCS11Exception | IOException throwable) {
            this.m_mainWindow.print("Exception : " + throwable.getMessage(), MainWindow.LogType.ScenarioError);
        }
        String string = null;
        try {
            object = this.m_pkcsInst.C_GetInfo();
            string = Integer.toString(object.cryptokiVersion.major) + "." + Integer.toString(object.cryptokiVersion.minor);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_GetInfo failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
        }
        object = "This sample demonstrates how to use the PKCS #11 API version \"" + string + "\" provided by " + hidProductName + " from a Java program.\n" + "It implements following scenarios:\n" + "        -    How to use a signature key to sign some data.\n" + "        -    How to login to the card.\n" + "        -    How to write a secret key on the card, use it to encrypt or decrypt some data and then delete it.\n" + "        -    How to generate an OTP.\n";
        this.m_mainWindow.showMessageDialog((String)object);
    }

    public void loginScenario() {
        this.m_mainWindow.print("Starting login scenario...", MainWindow.LogType.ScenarioBoundary);
        if (!this.preamble() || !this.openSession(false)) {
            this.postamble(false, false);
            this.m_mainWindow.print("Login scenario aborted!", MainWindow.LogType.ScenarioBoundary);
            return;
        }
        if (!this.getPINProperties()) {
            this.postamble(true, false);
            this.m_mainWindow.print("Login scenario aborted!", MainWindow.LogType.ScenarioBoundary);
            return;
        }
        if ((this.m_tokenInfo.flags & 0x40000L) == 262144L) {
            if (!this.isCardCanBeUnblocked()) {
                this.postamble(true, false);
                this.m_mainWindow.print("Login scenario aborted!", MainWindow.LogType.ScenarioBoundary);
                return;
            }
            if (!(!this.m_cardCanBeUnblocked || this.getUnlockCode() && this.unblockCard())) {
                this.postamble(true, false);
                this.m_mainWindow.print("Login scenario aborted!", MainWindow.LogType.ScenarioBoundary);
                return;
            }
        } else if ((this.m_tokenInfo.flags & 0x80000L) == 524288L) {
            if (!this.changePIN()) {
                this.postamble(true, false);
                this.m_mainWindow.print("Login scenario aborted!", MainWindow.LogType.ScenarioBoundary);
                return;
            }
        } else {
            if (!this.logIntoCardApplication(false)) {
                this.postamble(true, false);
                this.m_mainWindow.print("Login scenario aborted!", MainWindow.LogType.ScenarioBoundary);
                return;
            }
            this.m_mainWindow.print("Login successful.", MainWindow.LogType.ScenarioInfo);
        }
        this.postamble(true, true);
        this.m_mainWindow.print("Login scenario completed.", MainWindow.LogType.ScenarioBoundary);
    }

    public void dataSignatureScenario() {
        this.m_mainWindow.print("Starting Data signature scenario...", MainWindow.LogType.ScenarioBoundary);
        if (!this.preamble() || !this.openSession(false)) {
            this.postamble(false, false);
            this.m_mainWindow.print("Data signature scenario aborted!", MainWindow.LogType.ScenarioBoundary);
            return;
        }
        if (!(this.getSelectedCertificate() && this.getCertificateID() && this.logIntoCardApplication(false))) {
            this.postamble(true, false);
            this.m_mainWindow.print("Data signature scenario aborted!", MainWindow.LogType.ScenarioBoundary);
            return;
        }
        if (!(this.findPrivateKey() && this.signData() && this.findPublicKey() && this.verifySignature())) {
            this.postamble(true, true);
            this.m_mainWindow.print("Data signature scenario aborted!", MainWindow.LogType.ScenarioBoundary);
            return;
        }
        this.postamble(true, true);
        this.m_mainWindow.print("Data signature scenario completed.", MainWindow.LogType.ScenarioBoundary);
    }

    public void otpGenerationScenario() {
        this.m_mainWindow.print("Starting OTP generation scenario...", MainWindow.LogType.ScenarioBoundary);
        if (!this.preamble() || !this.openSession(false)) {
            this.postamble(false, false);
            this.m_mainWindow.print("OTP generation scenario aborted!", MainWindow.LogType.ScenarioBoundary);
            return;
        }
        if (!this.logIntoCardApplication(false)) {
            this.postamble(true, false);
            this.m_mainWindow.print("OTP generation scenario aborted!", MainWindow.LogType.ScenarioBoundary);
            return;
        }
        if (!(this.findOTPKey() && this.checkOTPGenerationType() && this.getOTP())) {
            this.postamble(true, true);
            this.m_mainWindow.print("OTP generation scenario aborted!", MainWindow.LogType.ScenarioBoundary);
            return;
        }
        this.postamble(true, true);
        this.m_mainWindow.print("OTP generation scenario completed.", MainWindow.LogType.ScenarioBoundary);
    }

    public void secretKeyUsageScenario() {
        this.m_mainWindow.print("Starting Secret key usage scenario...", MainWindow.LogType.ScenarioBoundary);
        if (!this.preamble() || !this.openSession(true)) {
            this.postamble(false, false);
            this.m_mainWindow.print("Secret key usage scenario aborted!", MainWindow.LogType.ScenarioBoundary);
            return;
        }
        if (!this.createObject() || !this.logIntoCardApplication(false)) {
            this.postamble(true, false);
            this.m_mainWindow.print("Secret key usage scenario aborted!", MainWindow.LogType.ScenarioBoundary);
            return;
        }
        if (!(this.findSecretKey() && this.encrypt() && this.decrypt() && this.logoutOfCardApplication())) {
            this.postamble(true, true);
            this.m_mainWindow.print("Secret key usage scenario aborted!", MainWindow.LogType.ScenarioBoundary);
            return;
        }
        if (!this.logIntoCardApplication(false)) {
            this.postamble(true, false);
            this.m_mainWindow.print("Secret key usage scenario aborted!", MainWindow.LogType.ScenarioBoundary);
            return;
        }
        if (!this.destroyObject()) {
            this.postamble(true, true);
            this.m_mainWindow.print("Secret key usage scenario aborted!", MainWindow.LogType.ScenarioBoundary);
            return;
        }
        this.postamble(true, true);
        this.m_mainWindow.print("Secret key usage scenario completed.", MainWindow.LogType.ScenarioBoundary);
    }

    public void postamble(boolean bl, boolean bl2) {
        if (bl2) {
            this.logoutOfCardApplication();
        }
        if (bl) {
            this.disconnect();
        }
    }

    public boolean getPINProperties() {
        try {
            this.m_tokenInfo = this.m_pkcsInst.C_GetTokenInfo(this.m_selectedSlot);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_GetTokenInfo failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        this.m_mainWindow.print("Min PIN length : " + this.m_tokenInfo.ulMinPinLen);
        this.m_mainWindow.print("Max PIN length : " + this.m_tokenInfo.ulMaxPinLen);
        return true;
    }

    public boolean isCardCanBeUnblocked() {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()};
        cK_ATTRIBUTEArray[0].type = 0L;
        cK_ATTRIBUTEArray[0].pValue = 0x8000080AL;
        long[] lArray = null;
        try {
            this.m_pkcsInst.C_FindObjectsInit(this.m_sessionHandle, cK_ATTRIBUTEArray, this.useUtf8);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_FindObjectsInit failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        try {
            lArray = this.m_pkcsInst.C_FindObjects(this.m_sessionHandle, 1L);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_FindObjects failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        if (lArray.length > 0) {
            this.m_unlockObjHandle = lArray[0];
            this.m_cardCanBeUnblocked = true;
        }
        try {
            this.m_pkcsInst.C_FindObjectsFinal(this.m_sessionHandle);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_FindObjectsFinal failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        return true;
    }

    public boolean getUnlockCode() {
        String string = null;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()};
        cK_ATTRIBUTEArray[0].type = 2147484480L;
        try {
            this.m_pkcsInst.C_GetAttributeValue(this.m_sessionHandle, this.m_unlockObjHandle, cK_ATTRIBUTEArray, this.useUtf8);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_GetAttributeValue failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        byte[] byArray = (byte[])cK_ATTRIBUTEArray[0].pValue;
        switch (byArray[0]) {
            case 0: {
                string = this.m_mainWindow.showPINDialog("Enter the unlock code");
                if (string == null) {
                    this.m_mainWindow.print("Operation canceled");
                    return false;
                }
                this.m_mechanism = new CK_MECHANISM();
                this.m_mechanism.mechanism = 0x80000801L;
                break;
            }
            case 2: {
                cK_ATTRIBUTEArray[0].type = 2147484481L;
                try {
                    this.m_pkcsInst.C_GetAttributeValue(this.m_sessionHandle, this.m_unlockObjHandle, cK_ATTRIBUTEArray, this.useUtf8);
                }
                catch (PKCS11Exception pKCS11Exception) {
                    this.m_mainWindow.print("C_GetAttributeValue failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
                    return false;
                }
                this.m_mainWindow.print("Challenge = " + Helper.byteArrayToASCIIString((byte[])cK_ATTRIBUTEArray[0].pValue));
                string = this.m_mainWindow.showPINDialog("Enter the challenge response");
                if (string == null) {
                    this.m_mainWindow.print("Operation canceled");
                    return false;
                }
                this.m_mechanism = new CK_MECHANISM();
                this.m_mechanism.mechanism = 0x80000802L;
                break;
            }
            default: {
                this.m_mainWindow.print("Unknown Challenge Requirement value.", MainWindow.LogType.ScenarioError);
                return false;
            }
        }
        string = string.replace("-", "");
        this.m_unlockCode = Helper.convAsciiHexToBin(string);
        return this.m_unlockCode != null;
    }

    public boolean unblockCard() {
        String string;
        String string2 = this.m_mainWindow.showPINDialog("Enter new PIN");
        if (!string2.equals(string = this.m_mainWindow.showPINDialog("Confirm new PIN"))) {
            this.m_mainWindow.print("PINs do not match.", MainWindow.LogType.ScenarioError);
            return false;
        }
        this.m_mainWindow.print("Unsupported features. A custom wrapper is needed.", MainWindow.LogType.ScenarioError);
        try {
            this.m_pkcsInst.C_Login(this.m_sessionHandle, 1L, string2.toCharArray(), this.useUtf8);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_Login failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        return true;
    }

    public boolean changePIN() {
        String string;
        String string2 = this.m_mainWindow.showPINDialog("Enter your PIN");
        String string3 = this.m_mainWindow.showPINDialog("Enter new PIN");
        if (!string3.equals(string = this.m_mainWindow.showPINDialog("Confirm new PIN"))) {
            this.m_mainWindow.print("PINs do not match.", MainWindow.LogType.ScenarioError);
            return false;
        }
        return true;
    }

    public boolean preamble() {
        this.listReaders();
        if (this.m_readerList == null || this.m_readerList.length == 0) {
            this.m_mainWindow.print("No card reader with a card inserted was detected.", MainWindow.LogType.ScenarioInfo);
            return false;
        }
        int n = this.m_mainWindow.showSelectionDialog("Select the reader", this.m_readerList);
        if (n == -1) {
            return false;
        }
        this.m_selectedSlot = this.m_slotsIDList[n];
        return true;
    }

    public boolean findPrivateKey() {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[4];
        cK_ATTRIBUTEArray[0] = new CK_ATTRIBUTE();
        cK_ATTRIBUTEArray[0].type = 1L;
        cK_ATTRIBUTEArray[0].pValue = true;
        cK_ATTRIBUTEArray[1] = new CK_ATTRIBUTE();
        cK_ATTRIBUTEArray[1].type = 2L;
        cK_ATTRIBUTEArray[1].pValue = true;
        cK_ATTRIBUTEArray[2] = new CK_ATTRIBUTE();
        cK_ATTRIBUTEArray[2].type = 0L;
        cK_ATTRIBUTEArray[2].pValue = 3L;
        cK_ATTRIBUTEArray[3] = new CK_ATTRIBUTE();
        cK_ATTRIBUTEArray[3].type = 258L;
        cK_ATTRIBUTEArray[3].pValue = this.m_selectedCertID;
        long[] lArray = null;
        try {
            this.m_pkcsInst.C_FindObjectsInit(this.m_sessionHandle, cK_ATTRIBUTEArray, this.useUtf8);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_FindObjectsInit failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        try {
            lArray = this.m_pkcsInst.C_FindObjects(this.m_sessionHandle, 1L);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_FindObjects failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        if (lArray.length == 0) {
            this.m_mainWindow.print("Private key not found.", MainWindow.LogType.ScenarioError);
            return false;
        }
        this.m_privateKeyHandle = lArray[0];
        try {
            this.m_pkcsInst.C_FindObjectsFinal(this.m_sessionHandle);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_FindObjectsFinal failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        return true;
    }

    public boolean findSecretKey() {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()};
        cK_ATTRIBUTEArray[0].type = 3L;
        cK_ATTRIBUTEArray[0].pValue = "label";
        long[] lArray = null;
        try {
            this.m_pkcsInst.C_FindObjectsInit(this.m_sessionHandle, cK_ATTRIBUTEArray, this.useUtf8);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_FindObjectsInit failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        try {
            lArray = this.m_pkcsInst.C_FindObjects(this.m_sessionHandle, 1L);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_FindObjects failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        if (lArray.length == 0) {
            this.m_mainWindow.print("Secret key not found.", MainWindow.LogType.ScenarioError);
            return false;
        }
        this.m_secretKeyHandle = lArray[0];
        try {
            this.m_pkcsInst.C_FindObjectsFinal(this.m_sessionHandle);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_FindObjectsFinal failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        return true;
    }

    public boolean checkOTPGenerationType() {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()};
        cK_ATTRIBUTEArray[0].type = 548L;
        try {
            this.m_pkcsInst.C_GetAttributeValue(this.m_sessionHandle, this.m_otpKeyHandle, cK_ATTRIBUTEArray, this.useUtf8);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_GetAttributeValue failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        byte[] byArray = (byte[])cK_ATTRIBUTEArray[0].pValue;
        if (byArray[0] != 0) {
            this.m_mainWindow.print("Only synchronous OTP generation is supported by this sample.", MainWindow.LogType.ScenarioError);
            return false;
        }
        return true;
    }

    public boolean findPublicKey() {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[4];
        cK_ATTRIBUTEArray[0] = new CK_ATTRIBUTE();
        cK_ATTRIBUTEArray[0].type = 1L;
        cK_ATTRIBUTEArray[0].pValue = true;
        cK_ATTRIBUTEArray[1] = new CK_ATTRIBUTE();
        cK_ATTRIBUTEArray[1].type = 266L;
        cK_ATTRIBUTEArray[1].pValue = true;
        cK_ATTRIBUTEArray[2] = new CK_ATTRIBUTE();
        cK_ATTRIBUTEArray[2].type = 0L;
        cK_ATTRIBUTEArray[2].pValue = 2L;
        cK_ATTRIBUTEArray[3] = new CK_ATTRIBUTE();
        cK_ATTRIBUTEArray[3].type = 258L;
        cK_ATTRIBUTEArray[3].pValue = this.m_selectedCertID;
        long[] lArray = null;
        try {
            this.m_pkcsInst.C_FindObjectsInit(this.m_sessionHandle, cK_ATTRIBUTEArray, this.useUtf8);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_FindObjectsInit failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        try {
            lArray = this.m_pkcsInst.C_FindObjects(this.m_sessionHandle, 1L);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_FindObjects failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        if (lArray.length == 0) {
            this.m_mainWindow.print("Public key not found.", MainWindow.LogType.ScenarioError);
            return false;
        }
        this.m_publicKeyHandle = lArray[0];
        try {
            this.m_pkcsInst.C_FindObjectsFinal(this.m_sessionHandle);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_FindObjectsFinal failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        return true;
    }

    public boolean findOTPKey() {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[2];
        cK_ATTRIBUTEArray[0] = new CK_ATTRIBUTE();
        cK_ATTRIBUTEArray[0].type = 0L;
        cK_ATTRIBUTEArray[0].pValue = 8;
        cK_ATTRIBUTEArray[1] = new CK_ATTRIBUTE();
        cK_ATTRIBUTEArray[1].type = 1L;
        cK_ATTRIBUTEArray[1].pValue = true;
        long[] lArray = null;
        try {
            this.m_pkcsInst.C_FindObjectsInit(this.m_sessionHandle, cK_ATTRIBUTEArray, this.useUtf8);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_FindObjectsInit failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        try {
            lArray = this.m_pkcsInst.C_FindObjects(this.m_sessionHandle, 1L);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_FindObjects failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        if (lArray.length == 0) {
            this.m_mainWindow.print("No OTP objects were found on the card.", MainWindow.LogType.ScenarioError);
            return false;
        }
        this.m_otpKeyHandle = lArray[0];
        try {
            this.m_pkcsInst.C_FindObjectsFinal(this.m_sessionHandle);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_FindObjectsFinal failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        return true;
    }

    public boolean encrypt() {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM();
        byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        cK_MECHANISM.mechanism = 310L;
        cK_MECHANISM.pParameter = byArray;
        try {
            this.m_pkcsInst.C_EncryptInit(this.m_sessionHandle, cK_MECHANISM, this.m_secretKeyHandle, this.useUtf8);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_EncryptInit failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        try {
            this.m_encryptedData = this.m_pkcsInst.C_Encrypt(this.m_sessionHandle, this.m_dataToEncrypt);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_Encrypt failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        this.m_mainWindow.print("Encrypted data:", MainWindow.LogType.ScenarioInfo);
        this.m_mainWindow.print(Helper.byteArrayToASCIIString(this.m_encryptedData), MainWindow.LogType.APIInfo);
        return true;
    }

    public boolean decrypt() {
        byte[] byArray;
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM();
        byte[] byArray2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        cK_MECHANISM.mechanism = 310L;
        cK_MECHANISM.pParameter = byArray2;
        try {
            this.m_pkcsInst.C_DecryptInit(this.m_sessionHandle, cK_MECHANISM, this.m_secretKeyHandle, this.useUtf8);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_DecryptInit failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        try {
            byArray = this.m_pkcsInst.C_Decrypt(this.m_sessionHandle, this.m_encryptedData);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_Decrypt failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        this.m_mainWindow.print("Decrypted data:", MainWindow.LogType.ScenarioInfo);
        this.m_mainWindow.print(Helper.byteArrayToASCIIString(byArray), MainWindow.LogType.APIInfo);
        if (!Helper.compareArrays(byArray, this.m_dataToEncrypt)) {
            this.m_mainWindow.print("Decrypted data and initial data are not equal!", MainWindow.LogType.ScenarioError);
            return false;
        }
        return true;
    }

    public boolean getSelectedCertificate() {
        if (!this.listCertificates()) {
            return false;
        }
        if (this.m_certList == null || this.m_certList.length == 0) {
            this.m_mainWindow.print("No certificate found on the card.");
            return false;
        }
        int n = this.m_mainWindow.showSelectionDialog("Select the certificate", this.m_certList);
        if (n == -1) {
            return false;
        }
        this.m_selectedCertificate = this.m_certHandleList[n];
        return true;
    }

    public boolean createObject() {
        if (!this.logIntoCardApplication(false)) {
            return false;
        }
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 17, 18, 19, 20, 21, 22, 23, 24, 33, 34, 35, 36, 37, 38, 39, 40};
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[8];
        cK_ATTRIBUTEArray[0] = new CK_ATTRIBUTE();
        cK_ATTRIBUTEArray[0].type = 1L;
        cK_ATTRIBUTEArray[0].pValue = true;
        cK_ATTRIBUTEArray[1] = new CK_ATTRIBUTE();
        cK_ATTRIBUTEArray[1].type = 2L;
        cK_ATTRIBUTEArray[1].pValue = true;
        cK_ATTRIBUTEArray[2] = new CK_ATTRIBUTE();
        cK_ATTRIBUTEArray[2].type = 0L;
        cK_ATTRIBUTEArray[2].pValue = 4L;
        cK_ATTRIBUTEArray[3] = new CK_ATTRIBUTE();
        cK_ATTRIBUTEArray[3].type = 3L;
        cK_ATTRIBUTEArray[3].pValue = "label";
        cK_ATTRIBUTEArray[4] = new CK_ATTRIBUTE();
        cK_ATTRIBUTEArray[4].type = 256L;
        cK_ATTRIBUTEArray[4].pValue = 21L;
        cK_ATTRIBUTEArray[5] = new CK_ATTRIBUTE();
        cK_ATTRIBUTEArray[5].type = 262L;
        cK_ATTRIBUTEArray[5].pValue = (byte)1;
        cK_ATTRIBUTEArray[6] = new CK_ATTRIBUTE();
        cK_ATTRIBUTEArray[6].type = 17L;
        cK_ATTRIBUTEArray[6].pValue = byArray;
        cK_ATTRIBUTEArray[7] = new CK_ATTRIBUTE();
        cK_ATTRIBUTEArray[7].type = 353L;
        cK_ATTRIBUTEArray[7].pValue = byArray.length;
        try {
            this.m_secretKeyHandle = this.m_pkcsInst.C_CreateObject(this.m_sessionHandle, cK_ATTRIBUTEArray, this.useUtf8);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_CreateObject failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        return this.logoutOfCardApplication();
    }

    public boolean destroyObject() {
        try {
            this.m_pkcsInst.C_DestroyObject(this.m_sessionHandle, this.m_secretKeyHandle);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_DestroyObject failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        return true;
    }

    public boolean getCertificateID() {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()};
        cK_ATTRIBUTEArray[0].type = 258L;
        try {
            this.m_pkcsInst.C_GetAttributeValue(this.m_sessionHandle, this.m_selectedCertificate, cK_ATTRIBUTEArray, this.useUtf8);
            this.m_selectedCertID = (byte[])cK_ATTRIBUTEArray[0].pValue;
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_GetAttributeValue failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        return true;
    }

    public boolean getOTP() {
        byte[] byArray;
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM();
        cK_MECHANISM.mechanism = 672L;
        try {
            this.m_pkcsInst.C_SignInit(this.m_sessionHandle, cK_MECHANISM, this.m_otpKeyHandle, this.useUtf8);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_SignInit failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        try {
            byArray = this.m_pkcsInst.C_Sign(this.m_sessionHandle, null);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_Sign failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        this.m_mainWindow.print("Generated OTP:");
        this.m_mainWindow.print(Helper.byteArrayToASCIIString(byArray), MainWindow.LogType.APIInfo);
        return true;
    }

    public void listReaders() {
        try {
            this.m_slotsIDList = this.m_pkcsInst.C_GetSlotList(true);
            this.m_readerList = new String[this.m_slotsIDList.length];
            for (int i = 0; i < this.m_slotsIDList.length; ++i) {
                CK_SLOT_INFO cK_SLOT_INFO = this.m_pkcsInst.C_GetSlotInfo(this.m_slotsIDList[i]);
                this.m_readerList[i] = new String(cK_SLOT_INFO.slotDescription);
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_GetSlotInfo failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
        }
    }

    public boolean openSession(boolean bl) {
        long l = bl ? 6L : 4L;
        try {
            this.m_sessionHandle = this.m_pkcsInst.C_OpenSession(this.m_selectedSlot, l, null, null);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_OpenSession failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        return true;
    }

    public boolean logoutOfCardApplication() {
        try {
            this.m_pkcsInst.C_Logout(this.m_sessionHandle);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_Logout failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        return true;
    }

    public void disconnect() {
        try {
            this.m_pkcsInst.C_CloseSession(this.m_sessionHandle);
        }
        catch (PKCS11Exception pKCS11Exception) {
            pKCS11Exception.printStackTrace();
        }
    }

    public boolean signData() {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM();
        cK_MECHANISM.mechanism = 5L;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()};
        cK_ATTRIBUTEArray[0].type = 514L;
        try {
            this.m_pkcsInst.C_GetAttributeValue(this.m_sessionHandle, this.m_privateKeyHandle, cK_ATTRIBUTEArray, this.useUtf8);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_GetAttributeValue failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        this.m_privateKeyIsPINAlways = (Boolean)cK_ATTRIBUTEArray[0].pValue;
        for (int i = 0; i < 2; ++i) {
            try {
                this.m_pkcsInst.C_SignInit(this.m_sessionHandle, cK_MECHANISM, this.m_privateKeyHandle, this.useUtf8);
            }
            catch (PKCS11Exception pKCS11Exception) {
                this.m_mainWindow.print("C_SignInit failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
                return false;
            }
            if (this.m_privateKeyIsPINAlways && !this.logIntoCardApplication(true)) {
                return false;
            }
            try {
                this.m_signedData = this.m_pkcsInst.C_Sign(this.m_sessionHandle, this.m_dataToSign);
            }
            catch (PKCS11Exception pKCS11Exception) {
                this.m_mainWindow.print("C_Sign failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
                return false;
            }
            this.m_mainWindow.print("Signed data:");
            this.m_mainWindow.print(Helper.byteArrayToASCIIString(this.m_signedData), MainWindow.LogType.APIInfo);
        }
        return true;
    }

    public boolean listCertificates() {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[3];
        cK_ATTRIBUTEArray[0] = new CK_ATTRIBUTE();
        cK_ATTRIBUTEArray[0].type = 0L;
        cK_ATTRIBUTEArray[0].pValue = 1L;
        cK_ATTRIBUTEArray[1] = new CK_ATTRIBUTE();
        cK_ATTRIBUTEArray[1].type = 1L;
        cK_ATTRIBUTEArray[1].pValue = true;
        cK_ATTRIBUTEArray[2] = new CK_ATTRIBUTE();
        cK_ATTRIBUTEArray[2].type = 135L;
        cK_ATTRIBUTEArray[2].pValue = 1;
        try {
            this.m_pkcsInst.C_FindObjectsInit(this.m_sessionHandle, cK_ATTRIBUTEArray, this.useUtf8);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_FindObjectsInit failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        try {
            this.m_certHandleList = this.m_pkcsInst.C_FindObjects(this.m_sessionHandle, 100L);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_FindObjects failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        this.m_certList = new String[this.m_certHandleList.length];
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()};
        cK_ATTRIBUTEArray2[0].type = 3L;
        try {
            for (int i = 0; i < this.m_certHandleList.length; ++i) {
                this.m_pkcsInst.C_GetAttributeValue(this.m_sessionHandle, this.m_certHandleList[i], cK_ATTRIBUTEArray2, this.useUtf8);
                this.m_certList[i] = new String((char[])cK_ATTRIBUTEArray2[0].pValue);
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_GetAttributeValue failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        try {
            this.m_pkcsInst.C_FindObjectsFinal(this.m_sessionHandle);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_FindObjectsFinal failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        return true;
    }

    public boolean logIntoCardApplication(boolean bl) {
        String string = this.m_mainWindow.showPINDialog();
        if (string == null) {
            this.m_mainWindow.print("Operation canceled");
            return false;
        }
        long l = bl ? 2L : 1L;
        try {
            this.m_pkcsInst.C_Login(this.m_sessionHandle, l, string.toCharArray(), this.useUtf8);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_Login failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        return true;
    }

    @Override
    public void runScenario(int n) {
        switch (n) {
            case 0: {
                this.dataSignatureScenario();
                break;
            }
            case 1: {
                this.loginScenario();
                break;
            }
            case 2: {
                this.secretKeyUsageScenario();
                break;
            }
            case 3: {
                this.otpGenerationScenario();
                break;
            }
            default: {
                this.m_mainWindow.print("Combo box state corrupt", MainWindow.LogType.ScenarioError);
            }
        }
    }

    public boolean verifySignature() {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM();
        cK_MECHANISM.mechanism = 5L;
        try {
            this.m_pkcsInst.C_VerifyInit(this.m_sessionHandle, cK_MECHANISM, this.m_publicKeyHandle, this.useUtf8);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_VerifyInit failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        try {
            this.m_pkcsInst.C_Verify(this.m_sessionHandle, this.m_dataToSign, this.m_signedData);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.m_mainWindow.print("C_Verify failed with error " + pKCS11Exception.getMessage(), MainWindow.LogType.APIError);
            return false;
        }
        return true;
    }
}

