/* ---------------------------------------------------------------------------
    2016 HID Global Corporation/ASSA ABLOY AB. All rights reserved.
 
   This program is an unpublished copyrighted work which is proprietary
   to HID Global. This computer program includes Confidential,
   Proprietary Information and is a Trade Secret of HID Global.
   Any use, disclosure, modification and/or reproduction is prohibited
   unless authorized in writing by HID Global.

   WARNING:  Unauthorized reproduction of this program as well as
   unauthorized preparation of derivative works based upon the
   program or distribution of copies by sale, rental, lease or
   lending are violations of federal copyright laws and state trade
   secret laws, punishable by civil and criminal penalties.
--------------------------------------------------------------------------- */

/*
 * BSId.h
 */

#ifndef __BSID_H__
#define __BSID_H__

#define LOG_MODULE_NAME	_T("ACBSI21")
#define BSI_DLL_NAME _T("acbsi21.dll")


/*
BSI Implementation Dependent Constants
*/
#define BSI_AUTHENTICATOR_MAX_LEN	0x000000FF 
#define BSI_KEY_LENGTH				0x00000040
#define BSI_ERROR_TEXT_LEN			255
#define BSI_RSA_NO_PAD				0xA3	
#define BSI_ECDSA_256_NO_PAD		0xA4
#define BSI_ECDSA_384_NO_PAD		0xA5//Dinesh Need to check if BSI is a standard and there is a constant value for ECC_NO_PAD.


/*
 * Access Method Types
 */

#define BSI_AM_XAUTH				0x02	/* External Authentication			*/
#define BSI_AM_SECURE_CHANNEL_GP	0x04	/* Secure Channel (global platform)	*/
#define BSI_AM_PIN					0x06	/* PIN code is required				*/
#define BSI_AM_SECURE_CHANNEL_ISO	0x0B	/* Secure Channel (ISO 7816-4)		*/


/*
 * Access Control Rules 
 */

#define BSI_ACR_ALWAYS				0x00	/* No access control rule is required */
#define	BSI_ACR_NEVER				0x01	/* Operation is never possible */
#define	BSI_ACR_XAUTH				0x02	/* External Authentication.	*/
#define BSI_ACR_XAUTH_OR_PIN		0x03	/* The object method can be accessed either after an External Authentication or after a successful PIN presentation	*/
#define BSI_SECURE_CHANNEL_GP		0x04	/* Secure Channel (Global Platform)	*/
#define BSI_SECURE_CHANNEL_OP		0x04	/* Secure Channel (Global Platform)(GSC 1.8)*/
#define BSI_ACR_PIN_ALWAYS			0x05	/* PIN must be verified immediately prior to service request. */
#define BSI_ACR_PIN					0x06	/* PIN code is required	*/
#define BSI_ACR_XAUTH_THEN_PIN		0x07	/* External Authentication followed by a PIN presentation */
#define BSI_ACR_UPDATE_ONCE			0x08	/* The target object can only be updated once during its lifetime */
#define BSI_ACR_PIN_THEN_XAUTH		0x09	/* PIN presentation followed by External Authentication	*/
#define BSI_SECURE_CHANNEL_ISO		0x0B	/* Secure Channel (ISO 7816-4) */
#define BSI_ACR_XAUTH_AND_PIN		0x0C	/*PIN presentation AND External Authentication in any order are required */


/*
 * Card Capabilities Bitmask Definitions
 */
#define BSI_GCCDM					0x00000001  
#define BSI_SKI						0x00000002  
#define BSI_PKI						0x00000004  
#define BSI_GCCDM_EXT				0x00000008  
#define BSI_SKI_EXT					0x00000010  
#define BSI_PKI_EXT					0x00000020

/*
 * Card Manager states
 */
#define BSI_CARD_OP_READY			0x01
#define BSI_CARD_LOCKED				0x02

/*
 * GSC-IS v2.1 Return Codes
 */
#define BSI_OK						0x00		/* Execution completed successfully. */
#define BSI_ACCESS_DENIED			0x01		/* The applicable ACR was not fulfilled. */
#define BSI_ACR_NOT_AVAILABLE		0x02		/* The specified ACR is incorrect. */
#define BSI_BAD_AID					0x03		/* The specified Application Identifiers (AID) does not exist. */
#define BSI_BAD_ALGO_ID				0x04		/* The specified cryptographic algorithm is not available. */
#define BSI_BAD_AUTH				0x05		/* Invalid authentication data. */
#define BSI_BAD_HANDLE				0x06		/* The specified card handle is not available. */
#define BSI_BAD_PARAM				0x07		/* One or more of the specified parameters is incorrect. */
#define BSI_BAD_TAG					0x08		/* Invalid tag information. */
#define BSI_CARD_ABSENT				0x09		/* The card associated with the specified card handle is not present. */
#define BSI_CARD_REMOVED			0x0A		/* The card associated with the specified card handle has been removed. */
#define BSI_NO_SPSSERVICE			0x0B		/* The SPS does not provide the requested service. */
#define BSI_IO_ERROR				0x0C		/* Error encountered during input/output of the specified data.. */
// RFU								0x0D		
#define BSI_INSUFFICIENT_BUFFER 	0x0E		/* The buffer allocated by the calling application is too small. */
#define BSI_NO_CARDSERVICE			0x0F		/* The smart card associated with the specified card handle does not provide the requested service. */
#define BSI_NO_MORE_SPACE			0x10		/* There is insufficient space in the selected container to store the specified data. */
#define BSI_PIN_BLOCKED				0x11		/* The PIN is locked. */
// RFU								0x12		
#define BSI_TAG_EXISTS				0x13		/* The tag specified for a create operation already exists in the target container. */
#define BSI_TIMEOUT_ERROR			0x14		/* A connection could not be established with the card before the timeout value expired. */
#define BSI_TERMINAL_AUTH			0X15		/* The card reader has performed a successful Internal Authentication with the card. */
#define BSI_NO_TEXT_AVAILABLE		0x16		/* No extended error text is available. */
#define BSI_UNKNOWN_ERROR			0x17		/* The requested operation has generated an unspecified error. */
#define BSI_UNKNOWN_READER			0x18		/* The specified reader does not exist. */
#define BSI_SC_LOCKED				0x19		/* The smart card associated with the specified card handle is under the exclusive transaction of another client application. */
#define BSI_NOT_TRANSACTED			0x20		/* The current transaction has not ended. */
#define BSI_NOT_IMPLEMENTED			0x21		/* The function is not implemented */
#endif /*__BSID_H__*/
