/* ---------------------------------------------------------------------------
    2016 HID Global Corporation/ASSA ABLOY AB. All rights reserved.
 
   This program is an unpublished copyrighted work which is proprietary
   to HID Global. This computer program includes Confidential,
   Proprietary Information and is a Trade Secret of HID Global.
   Any use, disclosure, modification and/or reproduction is prohibited
   unless authorized in writing by HID Global.

   WARNING:  Unauthorized reproduction of this program as well as
   unauthorized preparation of derivative works based upon the
   program or distribution of copies by sale, rental, lease or
   lending are violations of federal copyright laws and state trade
   secret laws, punishable by civil and criminal penalties.
--------------------------------------------------------------------------- */

/*
 * BSIt.h
 */

/* 
 * BSI Types 
 */

#ifndef __BSIT_H__
#define __BSIT_H__


/*
 * Unix definitions
*/
#ifndef WIN32

#ifndef BOOL_defined
typedef int BOOL;
#endif

#ifndef boolean_defined
typedef unsigned char boolean;
#endif

#define CALLBACK

#ifndef IN
#define IN
#endif

#ifndef OUT
#define OUT
#endif

#endif 

#define BSI_PTR				*

/*
 * Macros to provide consistency between BSI Types that 
 * differ between GSC-IS v1.8 and v2.0.  To ensure compatibility,
 * applications should use the identifiers defined here
 * rather than the equivalent C/C++ keywords.
 */
typedef int					BSI_SHORT;
typedef BSI_SHORT BSI_PTR	BSI_SHORT_PTR;
typedef unsigned int		BSI_USHORT;
typedef BSI_USHORT BSI_PTR	BSI_USHORT_PTR;
typedef long				BSI_LONG;
typedef	BSI_LONG BSI_PTR	BSI_LONG_PTR;
typedef unsigned long		BSI_ULONG;
typedef BSI_ULONG BSI_PTR	BSI_ULONG_PTR;

typedef BSI_ULONG			BSI_INT;
typedef BSI_ULONG			BSI_UINT;
typedef BSI_ULONG			BSI_RETURN;

#define BSI_INT_PTR			BSI_INT BSI_PTR
#define BSI_UINT_PTR		BSI_UINT BSI_PTR

/*
 * Other basic BSI types
 */
typedef char				BSI_CHAR;
typedef BSI_CHAR BSI_PTR	BSI_CHAR_PTR;
typedef unsigned char		BSI_BYTE;
typedef BSI_BYTE BSI_PTR	BSI_BYTE_PTR;

/*
 * BSI Implementation Dependent type definitions
 *
 * Note: Since there are differences between the GSC-IS 1.8
 *		 and the GSC-IS 2.0 specs for this structure, applications
 *		 should use the identifier BSI_GCT defined here
 *		 to ensure compatibility.
 */
typedef BSI_ULONG					UTILCardHandle;
typedef BSI_BYTE					GCtag;	/* GSC-IS v2.0 */
typedef GCtag						BSI_GCT;
typedef BSI_BYTE					gcTag;	/* for backward compatibility */
typedef BSI_GCT BSI_PTR				BSI_GCT_PTR;

typedef UTILCardHandle				BSI_CARD_HANDLE;		
typedef BSI_CARD_HANDLE BSI_PTR		BSI_CARD_HANDLE_PTR;		

typedef unsigned long   BSI_CARDHANDLE;

/*
 * Auhenticator structure
 */
typedef struct { 
	BSI_ULONG				unAccessMethodType; 
	BSI_ULONG				unKeyIDOrReference; 
	BSI_BYTE				uszAuthValue [BSI_AUTHENTICATOR_MAX_LEN]; 
	BSI_ULONG				unAuthValueLen; 
} BSIAuthenticator;

typedef BSIAuthenticator BSI_PTR	BSI_AUTH_PTR;

typedef struct strctContainerSizes
{ 
	BSI_ULONG	unMaxNbDataItems; 
	BSI_ULONG	unMaxValueStorageSize; 
} GCContainerSize;

typedef GCContainerSize			BSI_GC_SIZE;
typedef BSI_GC_SIZE BSI_PTR		BSI_GC_SIZE_PTR;


#define MaxNbAM 4

typedef struct strctBSIAcr
{
	BSI_ULONG	unACRType;
	BSI_ULONG	unKeyIDOrReference[MaxNbAM];
	BSI_ULONG	unAuthNb;
	BSI_ULONG	unACRID;
} BSIAcr;

/*
 * GC access right structure
 *
 */
typedef struct strctGCacr
{ 
	BSIAcr	strctCreateACR; 
	BSIAcr	strctDeleteACR; 
	BSIAcr	strctReadTagListACR; 
	BSIAcr	strctReadValueACR; 
	BSIAcr	strctUpdateValueACR; 
} GCacr;
typedef GCacr				GCAcr;	/* for backward compatibility */
typedef GCAcr				BSI_GC_ACR;
typedef BSI_GC_ACR BSI_PTR	BSI_GC_ACR_PTR;


/*
 * Crypto access right structure
 *
 * Note: Since there are differences between the GSC-IS 1.8
 *		 the GSC-IS 2.0 specs for this structure, applications
 *		 should use the identifier BSI_CRYPTO_ACR defined
 *		 here to ensure compatibility.
 */
typedef struct strctCRYPTOacr
{ 
	BSIAcr	strctGetChallengeACR; 
	BSIAcr	strctInternalAuthenticateACR; 
	BSIAcr	strctPkiComputeACR; 
	BSIAcr	strctCreateACR; 
	BSIAcr	strctDeleteACR; 
	BSIAcr	strctReadTagListACR; 
	BSIAcr	strctReadValueACR; 
	BSIAcr	strctUpdateValueACR; 
} CRYPTOacr;
typedef CRYPTOacr	CRYPTOAcr;
typedef CRYPTOAcr				BSI_CRYPTO_ACR;
typedef BSI_CRYPTO_ACR BSI_PTR	BSI_CRYPTO_ACR_PTR;

/*
 * Function pointer type definitions for BSI dlls
 *
 * Applications which explicitly load a BSI DLL should use
 * the function pointer types defined here to declare the
 * pointers to BSI functions.
 *
 * Example: 
 *
 * #include "BSI.h"								// include the function definition	
 * __gscBsiUtilConnect gscBsiUtilConnect;		// declare a pointer to a function
 * HINSTANCE hInst = LoadLibrary( "BSI.dll" );	// load the BSI DLL
 * gscBsiUtilConnect =							// initialize the function pointer
 *			(__gscBsiUtilConnect)GetProcAddress(m_hBSIDLL, "gscBsiUtilConnect");
 */
typedef BSI_RETURN (CALLBACK BSI_PTR __gscBsiUtilAcquireContext)( 
	IN 		BSI_CARD_HANDLE,					
	IN 		BSI_BYTE_PTR,				
	IN 		BSI_ULONG,				
	IN 		BSI_AUTH_PTR,	
	IN		BSI_ULONG					
); 

typedef BSI_RETURN (CALLBACK BSI_PTR __gscBsiUtilConnect)(
	IN 		BSI_BYTE_PTR,			
	IN 		BSI_ULONG,		
	OUT		BSI_CARD_HANDLE_PTR					
);

typedef BSI_RETURN (CALLBACK BSI_PTR __gscBsiUtilDisconnect)( 
	IN		BSI_CARD_HANDLE					
); 

typedef BSI_RETURN (CALLBACK BSI_PTR __gscBsiUtilBeginTransaction)( 
	IN		BSI_CARD_HANDLE,
	IN		BOOL
);

typedef BSI_RETURN (CALLBACK BSI_PTR __gscBsiUtilEndTransaction)( 
	IN		BSI_CARD_HANDLE
);

typedef BSI_RETURN (CALLBACK BSI_PTR __gscBsiUtilGetVersion )(
	OUT		BSI_BYTE_PTR,			
	IN OUT	BSI_ULONG_PTR			
); 
 

typedef BSI_RETURN (CALLBACK BSI_PTR __gscBsiUtilGetCardProperties)( 
	IN		BSI_CARD_HANDLE,					
	OUT		BSI_BYTE_PTR,		
	IN OUT	BSI_ULONG_PTR,			
	OUT		BSI_ULONG_PTR		
); 


typedef BSI_RETURN (CALLBACK BSI_PTR __gscBsiUtilGetCardStatus)( 
	IN		BSI_CARD_HANDLE					
); 
 

typedef BSI_RETURN (CALLBACK BSI_PTR __gscBsiUtilGetExtendedErrorText)( 
	IN		BSI_CARD_HANDLE,					
	OUT		BSI_CHAR_PTR
); 
 

typedef BSI_RETURN (CALLBACK BSI_PTR __gscBsiUtilGetReaderList)( 
	IN OUT	BSI_BYTE_PTR,		
	IN OUT	BSI_ULONG_PTR
); 


typedef BSI_RETURN (CALLBACK BSI_PTR __gscBsiUtilPassthru)( 
	IN 		BSI_CARD_HANDLE,				
	IN 		BSI_BYTE_PTR,	
	IN 		BSI_ULONG,	
	IN OUT	BSI_BYTE_PTR,	
	IN OUT	BSI_ULONG_PTR		
); 
 
typedef BSI_RETURN (CALLBACK BSI_PTR __gscBsiUtilReleaseContext)( 
	IN 		BSI_CARD_HANDLE,					
	IN 		BSI_BYTE_PTR,				
	IN 		BSI_ULONG				
); 

typedef BSI_RETURN (CALLBACK BSI_PTR __gscBsiGcDataCreate)( 
	IN 		BSI_CARD_HANDLE,					
 	IN 		BSI_BYTE_PTR,				
	IN 		BSI_ULONG,				
	IN 		BSI_GCT,					
 	IN 		BSI_BYTE_PTR,				
	IN 		BSI_ULONG				
); 
 
typedef BSI_RETURN (CALLBACK BSI_PTR __gscBsiGcDataDelete)( 
	IN 		BSI_CARD_HANDLE,					
	IN 		BSI_BYTE_PTR, 				
	IN 		BSI_ULONG, 				
	IN 		BSI_GCT 					
); 

typedef BSI_RETURN (CALLBACK BSI_PTR __gscBsiGcGetContainerProperties)( 
	IN 		BSI_CARD_HANDLE,					
	IN 		BSI_BYTE_PTR, 				
	IN 		BSI_ULONG, 				
	OUT 	BSI_GC_ACR_PTR, 			
	OUT 	BSI_GC_SIZE_PTR,	
	OUT 	BSI_BYTE_PTR		
); 
 
typedef BSI_RETURN (CALLBACK BSI_PTR __gscBsiGcReadTagList)( 
	IN 		BSI_CARD_HANDLE,					
	IN 		BSI_BYTE_PTR,				
	IN 		BSI_ULONG,				
	IN OUT 	BSI_GCT_PTR,				
	IN OUT 	BSI_ULONG_PTR
); 

typedef BSI_RETURN (CALLBACK BSI_PTR __gscBsiGcReadValue)( 
	IN 		BSI_CARD_HANDLE,				
	IN 		BSI_BYTE_PTR, 			
	IN 		BSI_ULONG, 			
	IN 		BSI_GCT, 				
	IN OUT 	BSI_BYTE_PTR, 			
	IN OUT 	BSI_ULONG_PTR	
); 
 
typedef BSI_RETURN (CALLBACK BSI_PTR __gscBsiGcUpdateValue)( 
	IN 		BSI_CARD_HANDLE,					
	IN 		BSI_BYTE_PTR, 				
	IN 		BSI_ULONG, 				
	IN 		BSI_GCT, 					
	IN 		BSI_BYTE_PTR, 				
	IN 		BSI_ULONG 				
); 
 
typedef BSI_RETURN (CALLBACK BSI_PTR __gscBsiGetChallenge)( 
	IN 		BSI_CARD_HANDLE,				
	IN 		BSI_BYTE_PTR, 			
	IN 		BSI_ULONG, 			
	IN OUT 	BSI_BYTE_PTR, 		
	IN OUT 	BSI_ULONG_PTR		
); 
 
typedef BSI_RETURN (CALLBACK BSI_PTR __gscBsiSkiInternalAuthenticate)( 
	IN 		BSI_CARD_HANDLE,					
 	IN 		BSI_BYTE_PTR, 				
	IN 		BSI_ULONG, 				
	IN 		BSI_BYTE,				
 	IN 		BSI_BYTE_PTR, 			
	IN 		BSI_ULONG, 		
	OUT		BSI_BYTE_PTR,			
 	IN OUT	BSI_ULONG_PTR 		
); 
 
typedef BSI_RETURN (CALLBACK BSI_PTR __gscBsiPkiCompute)( 
	IN 		BSI_CARD_HANDLE,				
	IN 		BSI_BYTE_PTR, 			
	IN 		BSI_ULONG, 			
	IN 		BSI_BYTE, 			
	IN 		BSI_BYTE_PTR,		
	IN 		BSI_ULONG, 		
	IN OUT 	BSI_BYTE_PTR, 		
	IN OUT 	BSI_ULONG_PTR		
);

typedef BSI_RETURN (CALLBACK BSI_PTR __gscBsiPkiGetCertificate)( 
	IN 		BSI_CARD_HANDLE,					
	IN 		BSI_BYTE_PTR, 				
	IN 		BSI_ULONG, 				
	OUT		BSI_BYTE_PTR, 		
	IN OUT	BSI_ULONG_PTR 		
); 
 
typedef BSI_RETURN (CALLBACK BSI_PTR __gscBsiGetCryptoProperties)( 
	IN 		BSI_CARD_HANDLE,					
	IN 		BSI_BYTE_PTR, 				
	IN 		BSI_ULONG, 				
	OUT 	BSI_CRYPTO_ACR_PTR,		
	OUT 	BSI_ULONG_PTR			
); 
 
typedef BSI_RETURN (CALLBACK BSI_PTR __gscXsiUtilGetCardATR)( 
	IN 		BSI_CARD_HANDLE,					
	IN OUT 	BSI_BYTE_PTR, 				
	IN OUT 	BSI_ULONG_PTR			
); 

typedef BSI_RETURN (CALLBACK BSI_PTR __gscXsiUtilGetCuid)( 
	IN 		BSI_CARD_HANDLE,					
	IN OUT 	BSI_BYTE_PTR, 				
	IN OUT 	BSI_ULONG_PTR			
); 

typedef BSI_RETURN (CALLBACK BSI_PTR __gscXsiUtilGetIdentifier)( 
	IN		BSI_CARD_HANDLE,
	IN OUT	BSI_BYTE_PTR,
	IN OUT	BSI_ULONG_PTR
);

typedef BSI_RETURN (CALLBACK BSI_PTR __gscXsiNotifySynchronizationStart)( 
	IN		BSI_CARD_HANDLE
);


typedef BSI_RETURN (CALLBACK BSI_PTR __gscXsiNotifySynchronizationEnd)( 
	IN		BSI_CARD_HANDLE
);

typedef BSI_RETURN (CALLBACK BSI_PTR __gscXsiUtilGetCardManagerState)( 
	IN		BSI_CARD_HANDLE,
	OUT		BSI_INT_PTR
);


typedef BSI_RETURN (CALLBACK BSI_PTR __gscXsiUtilChangePIN)( 
	IN		BSI_CARD_HANDLE,
	IN		BSI_BYTE_PTR,
	IN		BSI_ULONG,
	IN		BSI_BYTE_PTR,
	IN		BSI_ULONG,
	IN		BSI_BYTE_PTR,
	IN		BSI_ULONG
);


typedef BSI_RETURN (CALLBACK BSI_PTR __gscXsiUtilIsPINVerified)( 
	IN		BSI_CARD_HANDLE,
	IN		BSI_BYTE_PTR,
	IN		BSI_ULONG,
	OUT		int*
);

typedef BSI_RETURN (CALLBACK BSI_PTR __gscXsiUtilGetForceChangePIN)( 
	IN		BSI_CARD_HANDLE,
	IN		BSI_BYTE_PTR,
	IN		BSI_ULONG,
	OUT		BOOL*
);

#endif /*__BSIT_H__*/
