/* ---------------------------------------------------------------------------
    2016 HID Global Corporation/ASSA ABLOY AB.  All rights reserved.

   Redistribution and use in source and binary forms, with or without modification,
   are permitted provided that the following conditions are met:
      - Redistributions of source code must retain the above copyright notice,
        this list of conditions and the following disclaimer.
      - Redistributions in binary form must reproduce the above copyright notice,
        this list of conditions and the following disclaimer in the documentation
        and/or other materials provided with the distribution.
        THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
        AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
        THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
        ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
        FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
        (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
        LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
        ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
        (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
        THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 --------------------------------------------------------------------------- */

#ifndef __HELPER_H__
#define __HELPER_H__


/***************/
/** CONSTANTS **/
/***************/
/* Macros, defines, constants, ... */
#define CHAR_HEX(c) (((c)>='0' && (c)<='9') ? ((c) - '0') : ( ((c)>='a' && (c)<='f') ? ((c)-'a'+0x0a) : ((c)-'A'+0x0a) ))
#define HEX_CHAR(c) (((c)>=0 && (c)<=9) ? ((c) + '0') : ((c)+'A'-0x0a) )


typedef struct Reader
{
	BSI_BYTE	usReader[BUFSIZ];
	BSI_ULONG	unReaderLen;
}ReaderStruct;


void DisplayError (char *pszMessage, int nRet);
void AccessControlRuleToString (IN unsigned int unAccessRight, OUT TCHAR *szAccessRight);
int  ConvAsciiToBin (const char *pszDataIn, char *pszDataOut, int *nDataOutSize);
int  ConvBinToAscii (const char *pszDataIn, int nInDataLen, char *pszDataOut, int *nDataOutSize);


#endif // __HELPER_H__
