/* ---------------------------------------------------------------------------
    2016 HID Global Corporation/ASSA ABLOY AB.  All rights reserved.

   Redistribution and use in source and binary forms, with or without modification,
   are permitted provided that the following conditions are met:
      - Redistributions of source code must retain the above copyright notice,
        this list of conditions and the following disclaimer.
      - Redistributions in binary form must reproduce the above copyright notice,
        this list of conditions and the following disclaimer in the documentation
        and/or other materials provided with the distribution.
        THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
        AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
        THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
        ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
        FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
        (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
        LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
        ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
        (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
        THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 --------------------------------------------------------------------------- */

#include "stdafx.h"

#include "Helper.h"


void AccessControlRuleToString(IN unsigned int unAccessRight, OUT TCHAR *szAccessRight)
{
	switch (unAccessRight)
	{
		case BSI_ACR_ALWAYS:
			_stprintf_s(szAccessRight, BUFSIZ, _T("BSI_ACR_ALWAYS"));
			
			break;
	
		case BSI_ACR_NEVER:
			_stprintf_s(szAccessRight, BUFSIZ, _T("BSI_ACR_NEVER"));			
			break;

		case BSI_ACR_PIN:
			_stprintf_s(szAccessRight, BUFSIZ, _T("BSI_ACR_PIN"));
			break;

		case BSI_ACR_XAUTH:
			_stprintf_s(szAccessRight, BUFSIZ, _T("BSI_ACR_XAUTH"));		
			break;

		case BSI_ACR_XAUTH_THEN_PIN:
			_stprintf_s(szAccessRight, BUFSIZ, _T("BSI_ACR_XAUTH_THEN_PIN"));		
			break;

		case BSI_ACR_XAUTH_OR_PIN:
			_stprintf_s(szAccessRight, BUFSIZ, _T("BSI_ACR_XAUTH_OR_PIN"));		
			break;

		case BSI_SECURE_CHANNEL_OP:
			_stprintf_s(szAccessRight, BUFSIZ, _T("BSI_SECURE_CHANNEL_OP"));		
			break;

		case BSI_SECURE_CHANNEL_ISO:
			_stprintf_s(szAccessRight, BUFSIZ, _T("BSI_SECURE_CHANNEL_ISO"));		
			break;

		default : 
			_stprintf_s(szAccessRight, BUFSIZ, _T("UNKNOWN ACR : %d"), unAccessRight);			
			break;
	}

}


int ConvAsciiToBin(
		const char *pszDataIn,	/* String buffer to convert (size must be multiple of 2)*/
		char *pszDataOut,		/* Binary buffer*/
		int *nDataOutSize)		/* size of output buffer*/
{
  int nInLength;
  int i;

/* ----- Control the parameters -------- */

  if( !pszDataIn || 
      !pszDataOut )
      return -1;

  nInLength = (int)strlen(pszDataIn);

  /* data len must be even */
  if (nInLength % 2)
      return -1;

  /* must fit in the pszDataOut buffer */
  if (*nDataOutSize < (nInLength / 2) )
      return -1;

/* ------------------------------------ */
  
  for (i = 0 ; i < nInLength ; i += 2)
    pszDataOut[i / 2] = CHAR_HEX(pszDataIn[i + 1]) | (CHAR_HEX(pszDataIn[i]) << 4);
  
  *nDataOutSize = nInLength / 2;

  return 0;
}

int ConvBinToAscii( const char* pszDataIn,
				    int  nDataInLen,
				    char *pszDataOut,
					int  *nDataOutSize)
{
  int nInLength;
  int i;

/* ----- Control the parameters -------- */

  if( !pszDataIn || 
      !pszDataOut )
      return -1;

  nInLength = nDataInLen;


  /* must fit in the pszDataOut buffer */
  if (nDataOutSize==NULL || *nDataOutSize < (nInLength * 2) )
      return -1;

/* ------------------------------------ */
  
  for (i = 0 ; i < nInLength ; i ++){
    //pszDataOut[i / 2] = CHAR_HEX(pszDataIn[i + 1]) | (CHAR_HEX(pszDataIn[i]) << 4);
	pszDataOut[2*i] = HEX_CHAR((pszDataIn[i]&0xF0) >> 4);
	pszDataOut[2*i+1] = HEX_CHAR(pszDataIn[i]&0x0F);
  }
  
  *nDataOutSize = nInLength * 2;

  return 0;
}