/* ---------------------------------------------------------------------------
    2016 HID Global Corporation/ASSA ABLOY AB.  All rights reserved.

   Redistribution and use in source and binary forms, with or without modification,
   are permitted provided that the following conditions are met:
      - Redistributions of source code must retain the above copyright notice,
        this list of conditions and the following disclaimer.
      - Redistributions in binary form must reproduce the above copyright notice,
        this list of conditions and the following disclaimer in the documentation
        and/or other materials provided with the distribution.
        THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
        AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
        THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
        ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
        FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
        (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
        LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
        ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
        (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
        THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 --------------------------------------------------------------------------- */

#include "stdafx.h"

#include "Helper.h"
#include "Scenarios.UI.h"
#include "Scenarios.h"


/**********************/
/** GLOBAL VARIABLES **/
/**********************/

// Sample commands
#define BSI_TEST_DATASIGN		_T('1')
#define BSI_TEST_DATAREAD		_T('2')
#define BSI_TEST_PASSTHRU		_T('3')
#define BSI_QUIT				_T('Q')

/* card handle */	
BSI_CARD_HANDLE	g_hCard = (BSI_CARD_HANDLE) -1;


/***************/
/** FUNCTIONS **/
/***************/

int main(void)
{
	/* Local variables */
	BSI_RETURN		lResp = BSI_OK;
	TCHAR			cType;

	BOOL			nService = FALSE;
	TCHAR			szInputBuffer[BUFSIZ];
	int				i = 0;

	
	while (nService != TRUE)
	{
		i = 1;

		system("CLS");

		if (DisplayCopyRightAndHeader ()!= BSI_OK)
		{
			return -1;
		}

		cType = _T('\0'); // re-initialize user choice

		_tprintf(_T("\n"));
		_tprintf(_T("\n"));
		_tprintf(_T("==================\n"));
		_tprintf (_T("\n Select the scenario:\n"));
		_tprintf (_T("\n\t%d: Data signature"), i++);
		_tprintf (_T("\n\t%d: Data items read"), i++);
		_tprintf (_T("\n\t%d: APDUs sending"), i++);
		
		_tprintf(_T("\n"));
		_tprintf (_T("\n\tQ: Quit"));
		_tprintf (_T("\n"));

		GetString (_T("\nEnter your choice "), szInputBuffer, BUFSIZ);

		_stscanf_s (szInputBuffer, _T("%c"), &cType, 1);

		switch (cType)
		{
			case BSI_TEST_DATASIGN:
				ScenarioSignData();
				break;
			case BSI_TEST_DATAREAD:
				ScenarioReadData();
				break; 
			case BSI_TEST_PASSTHRU:
				ScenarioPassthru();
				break; 
			
			case BSI_QUIT:
			case BSI_QUIT + 32:
				/* disconnect before leaving to avoid card reset */ 
				if (g_hCard != -1)
				{
					_tprintf (_T("\n Disonnecting from reader\n"));
					lResp = gscBsiUtilDisconnect(g_hCard);
				}
				/* Set end of "while" */
				nService = TRUE;
				break;

			default:
				_tprintf (_T("\nUnknown command !\n"));
				break;

		} /* End of switch */

		if (nService==FALSE)
		{
			_tprintf_s(_T("\n"));
			_tprintf_s(_T("\n"));
			system("PAUSE");
		}

	} /* End while */

	_tprintf (_T("\nExiting program.\n"));
	
	return 0;
}
