/* ---------------------------------------------------------------------------
    2016 HID Global Corporation/ASSA ABLOY AB.  All rights reserved.

   Redistribution and use in source and binary forms, with or without modification,
   are permitted provided that the following conditions are met:
      - Redistributions of source code must retain the above copyright notice,
        this list of conditions and the following disclaimer.
      - Redistributions in binary form must reproduce the above copyright notice,
        this list of conditions and the following disclaimer in the documentation
        and/or other materials provided with the distribution.
        THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
        AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
        THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
        ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
        FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
        (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
        LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
        ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
        (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
        THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 --------------------------------------------------------------------------- */
 
#include "stdafx.h"

#include "Helper.h"
#include "Scenarios.UI.h"
#include "Scenarios.h"


/*
 * Name   : GetString
 * What   : Get the response on the screen
 * Remark :
 */
void GetString(const TCHAR *text,TCHAR *buffer, int buffer_size)
{
	/* Local variables */
	int	i;

	_tprintf(_T("\n%s : "), text);
	fflush(stdin);
	_fgetts(buffer, buffer_size-1, stdin);
	for (i = (int)_tcslen(buffer) - 1 ; i >= 0 ; i--)
	{
		if (buffer[i] == _T('\n'))
		{
			buffer[i] = _T('\0');
			break;
		}
	}
}

/*
 * Name   : DisplayError
 * What   : Display an error message
 * Remark :
 */
void DisplayError(char *pszMessage, int nRet)
{
	_tprintf(_T("%S"), pszMessage);

	switch (nRet)
	{

	case BSI_OK:
		_tprintf(_T("BSI_OK \n"));
		break;
	case BSI_ACCESS_DENIED:
		_tprintf(_T("BSI_ACCESS_DENIED \n"));
		break;
	case BSI_ACR_NOT_AVAILABLE:
		_tprintf(_T("BSI_ACR_NOT_AVAILABLE \n"));
		break;
	case BSI_BAD_AID:	
		_tprintf(_T("BSI_BAD_AID \n"));
		break;
	case BSI_BAD_ALGO_ID:	
		_tprintf(_T("BSI_BAD_ALGO_ID \n"));
		break;
	case BSI_BAD_AUTH:
		_tprintf(_T("BSI_BAD_AUTH \n"));
		break;
	case BSI_BAD_HANDLE:
		_tprintf(_T("BSI_BAD_HANDLE \n"));
		break;
	case BSI_BAD_PARAM:
		_tprintf(_T("BSI_BAD_PARAM \n"));
		break;
	case BSI_BAD_TAG:	
		_tprintf(_T("BSI_BAD_TAG \n"));
		break;
	case BSI_CARD_ABSENT:		
		_tprintf(_T("BSI_CARD_ABSENT \n"));
		break;
	case BSI_CARD_REMOVED:	
		_tprintf(_T("BSI_CARD_REMOVED \n"));
		break;
	case BSI_IO_ERROR:	
		_tprintf(_T("BSI_IO_ERROR \n"));
		break;
	case BSI_INSUFFICIENT_BUFFER:
		_tprintf(_T("BSI_INSUFFICIENT_BUFFER \n"));
		break;
	case BSI_NO_CARDSERVICE:	
		_tprintf(_T("BSI_NO_CARDSERVICE \n"));
		break;
	case BSI_NO_MORE_SPACE:	
		_tprintf(_T("BSI_NO_MORE_SPACE \n"));
		break;
	case BSI_PIN_BLOCKED:		
		_tprintf(_T("BSI_PIN_BLOCKED \n"));
		break;
	case BSI_TAG_EXISTS:		
		_tprintf(_T("BSI_TAG_EXISTS \n"));
		break;
	case BSI_TIMEOUT_ERROR:	
		_tprintf(_T("BSI_TIMEOUT_ERROR \n"));
		break;
	case BSI_TERMINAL_AUTH:	
		_tprintf(_T("BSI_TERMINAL_AUTH \n"));
		break;
	case BSI_NO_TEXT_AVAILABLE:
		_tprintf(_T("BSI_NO_TEXT_AVAILABLE \n"));
		break;
	case BSI_UNKNOWN_ERROR:	
		_tprintf(_T("BSI_UNKNOWN_ERROR \n"));
		break;
	case BSI_UNKNOWN_READER:	
		_tprintf(_T("BSI_UNKNOWN_READER \n"));
		break;
	case BSI_NO_SPSSERVICE:	
		_tprintf(_T("BSI_NO_SPSSERVICE (not implemented) \n"));
		break;
	case BSI_NOT_TRANSACTED:	
		_tprintf(_T("BSI_NOT_TRANSACTED\n"));
		break;
	case BSI_NOT_IMPLEMENTED:	
		_tprintf(_T("BSI_NOT_IMPLEMENTED\n"));
		break;
	default:	
		_tprintf(_T("Unknown error (%d)\n"), nRet);
		break;
	}
}


/* AIDs of applets present on a card can be displayed using the Advanced Diagnostics Tool provided by ActivClient 7.1 */
void GetContainerAID(const TCHAR* msg, BSI_BYTE_PTR pusAID, BSI_INT_PTR punAIDLen)
{
	TCHAR szInputBuffer[BUFSIZ];
	int i=0;
	size_t num_chars = 0;

	GetString(msg, szInputBuffer, BUFSIZ);

	if (_tcslen(szInputBuffer) > *punAIDLen*2)
	{
		memset(pusAID, 0, *punAIDLen);
		*punAIDLen = 0;
		return;
	}
	for (i = 0 ; (unsigned int) i < _tcslen(szInputBuffer) ; i++)
	{
		if (!_istxdigit(szInputBuffer[i]))
		{
			memset(pusAID, 0, *punAIDLen);
			*punAIDLen = 0;
			return;
		}
	}
	
	wcstombs_s (&num_chars, (char*)pusAID, (size_t)*punAIDLen, szInputBuffer, BUFSIZ);
	*punAIDLen = (int) _tcslen(szInputBuffer)+1;
	return;
}


void DisplayReadersList(unsigned char * usReaderList, unsigned int unReaderListLen, ReaderStruct *psReaderStruct, unsigned int *punReadersCount)
{
	int i=0;
	*punReadersCount = 0;

	for (i = 0 ; (unsigned int)i < unReaderListLen - 2 ; i += (int)_mbsnbcnt(_mbsninc(usReaderList+i,0), unReaderListLen - 2 - i )+ 1)
	{
		memcpy(psReaderStruct[*punReadersCount].usReader, _mbsninc(usReaderList+i,0),_mbsnbcnt(_mbsninc(usReaderList+i,0), unReaderListLen - 2 - i )+1);
		psReaderStruct[*punReadersCount].unReaderLen = (ULONG)_mbsnbcnt(_mbsninc(usReaderList+i,0), unReaderListLen - 2 - i );
		

		printf("\n\t %d: %s|",
					(*punReadersCount)+1,
					(char *) (psReaderStruct[*punReadersCount].usReader)); 
		(*punReadersCount)++;
	}
}

/**
* DisplayCopyRightAndHeader
*
* DisplayCopyRightAndHeader
*
*@return ...
*
*@param param1 ...
*@param param2 ...
*
*@see ...
*
*@version 1.0
**/
BSI_RETURN DisplayCopyRightAndHeader ()
{
	BSI_RETURN		lResp = BSI_OK;
	BSI_BYTE		usVersion[BUFSIZ];
	BSI_INT			nVersionLen = BUFSIZ;

	// print copyright
	_tprintf (_T("\n") LEGALCOPYRIGHT);

	// print header
	_tprintf (_T("\n\n") PRODUCTNAME);

	/* initialize input data length */
	nVersionLen = sizeof(usVersion);
	/* read data */
	lResp = gscBsiUtilGetVersion(
				usVersion,
				&nVersionLen);
	if (lResp != BSI_OK)
	{
		PrintExtendedErrorText();
		_tprintf (_T("\n\nError getting API version.\n"));
		return lResp;
	}
	

	_tprintf (_T("\n\n") DESCRIPTION, usVersion);

	return lResp;
}