/* ---------------------------------------------------------------------------
   © 2016 HID Global Corporation/ASSA ABLOY AB. All rights reserved.
 
   This program is an unpublished copyrighted work which is proprietary
   to HID Global. This computer program includes Confidential,
   Proprietary Information and is a Trade Secret of HID Global.
   Any use, disclosure, modification and/or reproduction is prohibited
   unless authorized in writing by HID Global.

   WARNING:  Unauthorized reproduction of this program as well as
   unauthorized preparation of derivative works based upon the
   program or distribution of copies by sale, rental, lease or
   lending are violations of federal copyright laws and state trade
   secret laws, punishable by civil and criminal penalties.
--------------------------------------------------------------------------- */

#ifndef __PIVF_H__
#define __PIVF_H__

#ifdef OS_ACUNIX
#define ACPIVAPI_API
#else
#ifdef ACPIVAPI_EXPORTS
#define ACPIVAPI_API __declspec(dllexport)
#else
#define ACPIVAPI_API __declspec(dllimport)
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define IN
#define OUT
#define INOUT

/* Entry Points for Communication */

ACPIVAPI_API PIV_RV pivMiddlewareVersion (OUT char * versionString);

ACPIVAPI_API PIV_RV pivConnect (IN		PIV_Bool sharedConnection, 
								INOUT	PIV_Byte *connectionDescription,
								INOUT	PIV_ULong32 *pCDLength,
								OUT		PIV_CARDHANDLE *pCardHandle);

ACPIVAPI_API PIV_RV pivDisconnect (IN	PIV_CARDHANDLE cardHandle);

/*  Entry Points for Data Access */
ACPIVAPI_API PIV_RV pivLogIntoCardApplication (IN	PIV_CARDHANDLE cardHandle, 
                                               IN	PIV_Byte *authenticators, 
                                               IN	PIV_ULong32 pAuthLength);

ACPIVAPI_API PIV_RV pivSelectCardApplication (IN	PIV_CARDHANDLE cardHandle, 
                                              IN	PIV_Byte *applicationAID, 
                                              IN	PIV_ULong32 aidLength, 
                                              OUT	PIV_Byte *applicationProperties, 
                                              INOUT	PIV_ULong32 *pAPLength);

ACPIVAPI_API PIV_RV pivGetData (IN		PIV_CARDHANDLE cardHandle, 
                                IN		PIV_Byte *OID, 
                                IN		PIV_ULong32 oidLength, 
                                OUT		PIV_Byte *data, 
                                INOUT	PIV_ULong32 *pDataLength);

ACPIVAPI_API PIV_RV pivLogoutOfCardApplication(IN PIV_CARDHANDLE cardHandle);

/*  Entry Points for Cryptographic Operations */
ACPIVAPI_API PIV_RV pivCrypt (IN	PIV_CARDHANDLE cardHandle, 
                              IN	PIV_Byte algID, 
                              IN	PIV_Byte keyReference, 
                              IN	PIV_Byte *algInput, 
                              IN	PIV_ULong32 inputLength,
							  OUT	PIV_Byte *algOutput, 
                              INOUT	PIV_ULong32 *pOutputLength);


/* Entry Points for Credential Initialization and Administration */
ACPIVAPI_API PIV_RV pivPutData (IN	PIV_CARDHANDLE cardHandle, 
                                IN	PIV_Byte *OID,
                                IN	PIV_ULong32 oidLength, 
                                IN	PIV_Byte *data, 
                                IN	PIV_ULong32 dataLength);

ACPIVAPI_API PIV_RV pivGenerateKeyPair (IN		PIV_CARDHANDLE cardHandle, 
                                        IN		PIV_Byte keyReference, 
										IN		PIV_Byte cryptographicMechanism,
										OUT		PIV_Byte *publicKey,
										INOUT	PIV_ULong32 *pKeyLength);

#ifdef __cplusplus
}
#endif

#endif /*__PIVF_H__*/
