/* ---------------------------------------------------------------------------
    2016 HID Global Corporation/ASSA ABLOY AB.  All rights reserved.

   Redistribution and use in source and binary forms, with or without modification,
   are permitted provided that the following conditions are met:
      - Redistributions of source code must retain the above copyright notice,
        this list of conditions and the following disclaimer.
      - Redistributions in binary form must reproduce the above copyright notice,
        this list of conditions and the following disclaimer in the documentation
        and/or other materials provided with the distribution.
        THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
        AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
        THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
        ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
        FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
        (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
        LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
        ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
        (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
        THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 --------------------------------------------------------------------------- */

#ifndef __SCENARIOS_UI_H__
#define __SCENARIOS_UI_H__

#define PRODUCTNAME		_T("HID Global PIV API C sample")
#define LEGALCOPYRIGHT	_T("Copyright \xb8 2016 HID Global Corporation/ASSA ABLOY AB. All rights reserved.")

#define DESCRIPTION		_T("This sample demonstrates how to use the PIV API version %S provided by ActivClient 7.1 from a C program.\nIt implements following scenarios:\n\t- How to use a PIV signature key to sign some data.\n\t- How to read PIV objects from the card.")

// Common UI functions
void			DisplayMenuHeader();
void			DisplayInputMenu(LPCWSTR szMenu, LPCWSTR szFormat, LPVOID pArgument);
void			DisplayPINInput(LPBYTE ucPIN, PDWORD pcbPIN);
DWORD			DisplayBinInHex(PBYTE pbData, DWORD cbData);

// Specific UI functions
BOOL				GetSelectedReader(LPSTR szSelectedReader, const DWORD cbSelectedReader);
CERTIFICATE_INDEX	GetSelectedCertificate(const PIV_CARDHANDLE cardHandle);
OBJECT_INDEX		GetSelectedObject(const PIV_CARDHANDLE cardHandle);

#endif // __SCENARIOS_UI_H__
