/* ---------------------------------------------------------------------------
    2016 HID Global Corporation/ASSA ABLOY AB.  All rights reserved.

   Redistribution and use in source and binary forms, with or without modification,
   are permitted provided that the following conditions are met:
      - Redistributions of source code must retain the above copyright notice,
        this list of conditions and the following disclaimer.
      - Redistributions in binary form must reproduce the above copyright notice,
        this list of conditions and the following disclaimer in the documentation
        and/or other materials provided with the distribution.
        THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
        AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
        THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
        ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
        FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
        (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
        LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
        ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
        (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
        THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 --------------------------------------------------------------------------- */

#ifndef __SCENARIOS_H__
#define __SCENARIOS_H__

// *************************************************************************************** //
//   NIST Special Publication 800-73-3: Personal Identity Verification (PIV) definitions   //
// *************************************************************************************** //

// Short PIV Card Application AID
#define PIV_CARD_APPLICATION_AID_RIGHTTRONCATED		{0xA0, 0x00, 0x00, 0x03, 0x08, 0x00, 0x00, 0x10, 0x00}

// Label of Data Object for Interoperable Use
#define OBJECT_LABEL_CARD_COMPABILITY_CONTAINER		"Card Capability Container"
#define OBJECT_LABEL_CARD_HOLDER_UNIQUE_IDENTIFIER	"Card Holder Unique Identifier"
#define OBJECT_LABEL_X509_PIV_AUTHENTICATION		"X.509 Certificate for PIV Authentication"
#define OBJECT_LABEL_CARDHOLDER_FINGERPRINTS		"Cardholder Fingerprints"
#define OBJECT_LABEL_SECURITY_OBJECT				"Security Object"
#define OBJECT_LABEL_CARDHOLDER_FACIAL_IMAGE		"Cardholder Facial Image"
#define OBJECT_LABEL_PRINTED_INFORMATION			"Printed Information"
#define OBJECT_LABEL_X509_DIGITAL_SIGNATURE			"X.509 Certificate for Digital Signature"
#define OBJECT_LABEL_X509_KEY_MANAGEMENT			"X.509 Certificate for Key Management"
#define OBJECT_LABEL_X509_CARD_AUTHENTICATION		"X.509 Certificate for Card Authentication"
#define OBJECT_LABEL_DISCOVERY_OBJECT				"Discovery Object"
#define OBJECT_LABEL_KEY_HISTORY_OBJECT				"Key History Object"
#define OBJECT_LABEL_RETIRED_X509_KEY_MANAGEMENT_1	"Retired X.509 Certificate for Key Management 1"
#define OBJECT_LABEL_RETIRED_X509_KEY_MANAGEMENT_2	"Retired X.509 Certificate for Key Management 2"
#define OBJECT_LABEL_RETIRED_X509_KEY_MANAGEMENT_3	"Retired X.509 Certificate for Key Management 3"
#define OBJECT_LABEL_RETIRED_X509_KEY_MANAGEMENT_4	"Retired X.509 Certificate for Key Management 4"
#define OBJECT_LABEL_RETIRED_X509_KEY_MANAGEMENT_5	"Retired X.509 Certificate for Key Management 5"
#define OBJECT_LABEL_RETIRED_X509_KEY_MANAGEMENT_6	"Retired X.509 Certificate for Key Management 6"
#define OBJECT_LABEL_RETIRED_X509_KEY_MANAGEMENT_7	"Retired X.509 Certificate for Key Management 7"
#define OBJECT_LABEL_RETIRED_X509_KEY_MANAGEMENT_8	"Retired X.509 Certificate for Key Management 8"
#define OBJECT_LABEL_RETIRED_X509_KEY_MANAGEMENT_9	"Retired X.509 Certificate for Key Management 9"
#define OBJECT_LABEL_RETIRED_X509_KEY_MANAGEMENT_10	"Retired X.509 Certificate for Key Management 10"
#define OBJECT_LABEL_RETIRED_X509_KEY_MANAGEMENT_11	"Retired X.509 Certificate for Key Management 11"
#define OBJECT_LABEL_RETIRED_X509_KEY_MANAGEMENT_12	"Retired X.509 Certificate for Key Management 12"
#define OBJECT_LABEL_RETIRED_X509_KEY_MANAGEMENT_13	"Retired X.509 Certificate for Key Management 13"
#define OBJECT_LABEL_RETIRED_X509_KEY_MANAGEMENT_14	"Retired X.509 Certificate for Key Management 14"
#define OBJECT_LABEL_RETIRED_X509_KEY_MANAGEMENT_15	"Retired X.509 Certificate for Key Management 15"
#define OBJECT_LABEL_RETIRED_X509_KEY_MANAGEMENT_16	"Retired X.509 Certificate for Key Management 16"
#define OBJECT_LABEL_RETIRED_X509_KEY_MANAGEMENT_17	"Retired X.509 Certificate for Key Management 17"
#define OBJECT_LABEL_RETIRED_X509_KEY_MANAGEMENT_18	"Retired X.509 Certificate for Key Management 18"
#define OBJECT_LABEL_RETIRED_X509_KEY_MANAGEMENT_19	"Retired X.509 Certificate for Key Management 19"
#define OBJECT_LABEL_RETIRED_X509_KEY_MANAGEMENT_20	"Retired X.509 Certificate for Key Management 20"
#define OBJECT_LABEL_CARDHOLDER_IRIS_IMAGES			"Cardholder Iris Images"

// OID of Data Object for Interoperable Use
#define OBJECT_OID_CARD_COMPABILITY_CONTAINER		"2.16.840.1.101.3.7.1.219.0"
#define OBJECT_OID_CARD_HOLDER_UNIQUE_IDENTIFIER	"2.16.840.1.101.3.7.2.48.0"
#define OBJECT_OID_X509_PIV_AUTHENTICATION			"2.16.840.1.101.3.7.2.1.1"
#define OBJECT_OID_CARDHOLDER_FINGERPRINTS			"2.16.840.1.101.3.7.2.96.16"
#define OBJECT_OID_SECURITY_OBJECT					"2.16.840.1.101.3.7.2.144.0"
#define OBJECT_OID_CARDHOLDER_FACIAL_IMAGE			"2.16.840.1.101.3.7.2.96.48"
#define OBJECT_OID_PRINTED_INFORMATION				"2.16.840.1.101.3.7.2.48.1"
#define OBJECT_OID_X509_DIGITAL_SIGNATURE			"2.16.840.1.101.3.7.2.1.0"
#define OBJECT_OID_X509_KEY_MANAGEMENT				"2.16.840.1.101.3.7.2.1.2"
#define OBJECT_OID_X509_CARD_AUTHENTICATION			"2.16.840.1.101.3.7.2.5.0"
#define OBJECT_OID_DISCOVERY_OBJECT					"2.16.840.1.101.3.7.2.96.80"
#define OBJECT_OID_KEY_HISTORY_OBJECT				"2.16.840.1.101.3.7.2.96.96"
#define OBJECT_OID_RETIRED_X509_KEY_MANAGEMENT_1	"2.16.840.1.101.3.7.2.16.1"
#define OBJECT_OID_RETIRED_X509_KEY_MANAGEMENT_2	"2.16.840.1.101.3.7.2.16.2"
#define OBJECT_OID_RETIRED_X509_KEY_MANAGEMENT_3	"2.16.840.1.101.3.7.2.16.3"
#define OBJECT_OID_RETIRED_X509_KEY_MANAGEMENT_4	"2.16.840.1.101.3.7.2.16.4"
#define OBJECT_OID_RETIRED_X509_KEY_MANAGEMENT_5	"2.16.840.1.101.3.7.2.16.5"
#define OBJECT_OID_RETIRED_X509_KEY_MANAGEMENT_6	"2.16.840.1.101.3.7.2.16.6"
#define OBJECT_OID_RETIRED_X509_KEY_MANAGEMENT_7	"2.16.840.1.101.3.7.2.16.7"
#define OBJECT_OID_RETIRED_X509_KEY_MANAGEMENT_8	"2.16.840.1.101.3.7.2.16.8"
#define OBJECT_OID_RETIRED_X509_KEY_MANAGEMENT_9	"2.16.840.1.101.3.7.2.16.9"
#define OBJECT_OID_RETIRED_X509_KEY_MANAGEMENT_10	"2.16.840.1.101.3.7.2.16.10"
#define OBJECT_OID_RETIRED_X509_KEY_MANAGEMENT_11	"2.16.840.1.101.3.7.2.16.11"
#define OBJECT_OID_RETIRED_X509_KEY_MANAGEMENT_12	"2.16.840.1.101.3.7.2.16.12"
#define OBJECT_OID_RETIRED_X509_KEY_MANAGEMENT_13	"2.16.840.1.101.3.7.2.16.13"
#define OBJECT_OID_RETIRED_X509_KEY_MANAGEMENT_14	"2.16.840.1.101.3.7.2.16.14"
#define OBJECT_OID_RETIRED_X509_KEY_MANAGEMENT_15	"2.16.840.1.101.3.7.2.16.15"
#define OBJECT_OID_RETIRED_X509_KEY_MANAGEMENT_16	"2.16.840.1.101.3.7.2.16.16"
#define OBJECT_OID_RETIRED_X509_KEY_MANAGEMENT_17	"2.16.840.1.101.3.7.2.16.17"
#define OBJECT_OID_RETIRED_X509_KEY_MANAGEMENT_18	"2.16.840.1.101.3.7.2.16.18"
#define OBJECT_OID_RETIRED_X509_KEY_MANAGEMENT_19	"2.16.840.1.101.3.7.2.16.19"
#define OBJECT_OID_RETIRED_X509_KEY_MANAGEMENT_20	"2.16.840.1.101.3.7.2.16.20"
#define OBJECT_OID_CARDHOLDER_IRIS_IMAGES			"2.16.840.1.101.3.7.2.16.21"

// Cryptographic Key Reference Identifiers
#define KEYREFERENCEID_PIV_AUTHENTICATION			0x9A
#define KEYREFERENCEID_SIGNATURE					0x9C
#define KEYREFERENCEID_KEY_MANAGEMENT				0x9D
#define KEYREFERENCEID_CARD_AUTHENTICATION			0x9E

// Cryptographic Algorithm Identifiers
#define ALGORITHMID_RSA_1024						0x06
#define ALGORITHMID_RSA_2048						0x07

// Data Objects in a Connection Description tag
#define CONNECTIONDESCRIPTIONTAG_INITIALIZE_1		0x7f
#define CONNECTIONDESCRIPTIONTAG_INITIALIZE_2		0x21
#define CONNECTIONDESCRIPTIONTAG_CARD_READER_NAME	0x81
#define CONNECTIONDESCRIPTIONTAG_NETWORK_NODE_LOCAL	0x90

#define BER_TAG_CHALLENGE							0x81
#define BER_TAG_RESPONSE							0x82


// *************************************************************************************** //
//   Sample definitions																	   //
// *************************************************************************************** //

#define INVALID_CARD_HANDLE	(PIV_CARDHANDLE)(0)

#define ERROR_PIV_API					ERROR_SUCCESS + 16000

// certTable index
typedef enum _CERTIFICATE_INDEX
{
    CERTIFICATE_INDEX_NO_CERTIFICATE = -1,
    CERTIFICATE_INDEX_PIV_AUTHENTICATION = 0,
    CERTIFICATE_INDEX_DIGITAL_SIGNATURE,
    CERTIFICATE_INDEX_CARD_AUTHENTICATION
} CERTIFICATE_INDEX;

// Security condition for use
typedef enum _SECURITY_CONDITION
{
    SECURITY_CONDITION_ALWAYS,
    SECURITY_CONDITION_PIN,
    SECURITY_CONDITION_PIN_ALWAYS
} SECURITY_CONDITION;

// Usefull certificates information
typedef struct _CERTIFICATE_INFO
{
    LPSTR				szCertificateLabel;
    LPSTR				szCertOID;
    PIV_Byte			keyReference;
    SECURITY_CONDITION	securityCondition;
} CERTIFICATE_INFO;

// objectTable index
typedef enum _OBJECT_INDEX
{
	OBJECT_INDEX_NO_OBJECT = -1,
	OBJECT_INDEX_CARD_COMPABILITY_CONTAINER = 0,
	OBJECT_INDEX_CARD_HOLDER_UNIQUE_IDENTIFIER,
	OBJECT_INDEX_X509_PIV_AUTHENTICATION,
	OBJECT_INDEX_CARDHOLDER_FINGERPRINTS,
	OBJECT_INDEX_SECURITY_OBJECT,
	OBJECT_INDEX_CARDHOLDER_FACIAL_IMAGE,
	OBJECT_INDEX_PRINTED_INFORMATION,
	OBJECT_INDEX_X509_DIGITAL_SIGNATURE,
	OBJECT_INDEX_X509_KEY_MANAGEMENT,
	OBJECT_INDEX_X509_CARD_AUTHENTICATION,
	OBJECT_INDEX_DISCOVERY_OBJECT,
	OBJECT_INDEX_KEY_HISTORY_OBJECT,
	OBJECT_INDEX_RETIRED_X509_KEY_MANAGEMENT_1,
	OBJECT_INDEX_RETIRED_X509_KEY_MANAGEMENT_2,
	OBJECT_INDEX_RETIRED_X509_KEY_MANAGEMENT_3,
	OBJECT_INDEX_RETIRED_X509_KEY_MANAGEMENT_4,
	OBJECT_INDEX_RETIRED_X509_KEY_MANAGEMENT_5,
	OBJECT_INDEX_RETIRED_X509_KEY_MANAGEMENT_6,
	OBJECT_INDEX_RETIRED_X509_KEY_MANAGEMENT_7,
	OBJECT_INDEX_RETIRED_X509_KEY_MANAGEMENT_8,
	OBJECT_INDEX_RETIRED_X509_KEY_MANAGEMENT_9,
	OBJECT_INDEX_RETIRED_X509_KEY_MANAGEMENT_10,
	OBJECT_INDEX_RETIRED_X509_KEY_MANAGEMENT_11,
	OBJECT_INDEX_RETIRED_X509_KEY_MANAGEMENT_12,
	OBJECT_INDEX_RETIRED_X509_KEY_MANAGEMENT_13,
	OBJECT_INDEX_RETIRED_X509_KEY_MANAGEMENT_14,
	OBJECT_INDEX_RETIRED_X509_KEY_MANAGEMENT_15,
	OBJECT_INDEX_RETIRED_X509_KEY_MANAGEMENT_16,
	OBJECT_INDEX_RETIRED_X509_KEY_MANAGEMENT_17,
	OBJECT_INDEX_RETIRED_X509_KEY_MANAGEMENT_18,
	OBJECT_INDEX_RETIRED_X509_KEY_MANAGEMENT_19,
	OBJECT_INDEX_RETIRED_X509_KEY_MANAGEMENT_20,
	OBJECT_INDEX_CARDHOLDER_IRIS_IMAGES
} OBJECT_INDEX;

// Access rule for read
typedef enum _ACCESS_RULE
{
	ACCESS_RULE_ALWAYS,
	ACCESS_RULE_PIN,
} ACCESS_RULE;

// Usefull certificates information
typedef struct _OBJECT_INFO
{
	LPSTR			szObjectLabel;
	LPSTR			szObjectOID;
	ACCESS_RULE		accessRule;
} OBJECT_INFO;

// Scenario functions
BOOL			PIVSignature();
BOOL			PIVObjectsRead();

// Common scenario functions
BOOL			Preamble(PIV_CARDHANDLE* cardHandle);
BOOL			Postamble(PIV_CARDHANDLE* cardHandle, LPBOOL pbLoggedIn);

// Common PIV wrapper functions
DWORD			ListReaders(LPSTR szReadersList, PDWORD pcbReadersList);
DWORD			Connect(PIV_RV* pivRet, PIV_CARDHANDLE* cardHandle, LPCSTR szReader, const DWORD cbReader);
DWORD			Disconnect(PIV_RV* pivRet, PIV_CARDHANDLE cardHandle);
DWORD			SelectCardApplication(PIV_RV* pivRet, const PIV_CARDHANDLE cardHandle);
DWORD			LogIntoCardApplication(PIV_RV* pivRet, const PIV_CARDHANDLE cardHandle, LPBYTE ucPIN, const DWORD cbPIN);
DWORD			LogoutOfCardApplication(PIV_RV* pivRet, const PIV_CARDHANDLE cardHandle);

// PIV signature wrapper functions
DWORD			ListCertificates(const PIV_CARDHANDLE cardHandle, CERTIFICATE_INDEX* pCertificates, PDWORD pcbCertificates);
DWORD			SignData(PIV_RV* pivRet, const PIV_CARDHANDLE Cardhandle, LPCBYTE ucDataToSign, const DWORD cbDataToSign, PIV_Byte keyReference, LPBYTE ucSignature, PDWORD pcbSignature);

// PIV objects read wrapper functions
DWORD			ListObjects(const PIV_CARDHANDLE cardHandle, OBJECT_INDEX* pObjects, PDWORD pcbObjects);
DWORD			ReadObject(PIV_RV* pivRet, const PIV_CARDHANDLE cardHandle, const OBJECT_INDEX nObjectIndex, LPBYTE ucObjectData, PDWORD pcbObjectData);


#endif // __SCENARIOS_H__
