/* ---------------------------------------------------------------------------
    2016 HID Global Corporation/ASSA ABLOY AB.  All rights reserved.

   Redistribution and use in source and binary forms, with or without modification,
   are permitted provided that the following conditions are met:
      - Redistributions of source code must retain the above copyright notice,
        this list of conditions and the following disclaimer.
      - Redistributions in binary form must reproduce the above copyright notice,
        this list of conditions and the following disclaimer in the documentation
        and/or other materials provided with the distribution.
        THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
        AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
        THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
        ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
        FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
        (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
        LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
        ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
        (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
        THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 --------------------------------------------------------------------------- */

#include "stdafx.h"

#include "Helper.h"


void GetString(LPCWSTR text, LPWSTR buffer, int buffer_size)
{
	/* Local variables */
	int	i;

	if ((NULL == text) || (NULL == buffer) || (0 == buffer_size))
	{
		return;
	}

	wprintf(L"\n%s: ", text);
	fflush(stdin);
	fgetws(buffer, buffer_size-1, stdin);
	for (i = (int)wcslen(buffer) - 1 ; i >= 0 ; i--)
	{
		if (buffer[i] == L'\n')
		{
			buffer[i] = L'\0';
			break;
		}
	}
}


LPCWSTR GetPivErrorString(PIV_RV pivret)
{
	//Return error description
	switch(pivret)
	{
	case PIV_OK:
		return L"No Error";

	case PIV_CONNECTION_DESCRIPTION_MALFORMED:
		return L"PIV_CONNECTION_DESCRIPTION_MALFORMED";

	case PIV_CONNECTION_FAILURE:
		return L"PIV_CONNECTION_FAILURE";

	case PIV_CONNECTION_LOCKED:
		return L"PIV_CONNECTION_LOCKED";

	case PIV_INVALID_CARD_HANDLE:
		return L"PIV_INVALID_CARD_HANDLE";

	case PIV_CARD_APPLICATION_NOT_FOUND:
		return L"PIV_CARD_APPLICATION_NOT_FOUND";

	case PIV_AUTHENTICATOR_MALFORMED:
		return L"PIV_AUTHENTICATOR_MALFORMED";

	case PIV_AUTHENTICATION_FAILURE:
		return L"PIV_AUTHENTICATION_FAILURE";

	case PIV_INVALID_OID:
		return L"PIV_INVALID_OID";

	case PIV_DATA_OBJECT_NOT_FOUND:
		return L"PIV_DATA_OBJECT_NOT_FOUND";

	case PIV_SECURITY_CONDITIONS_NOT_SATISFIED:
		return L"PIV_SECURITY_CONDITIONS_NOT_SATISFIED";

	case PIV_INVALID_KEYREF_OR_ALGORITHM:
		return L"PIV_INVALID_KEYREF_OR_ALGORITHM or PIV_INVALID_KEY_OR_KEYALG_COMBINATION";

	case PIV_INPUT_BYTES_MALFORMED:
		return L"PIV_INPUT_BYTES_MALFORMED";

	case PIV_INSUFFICIENT_CARD_RESOURCE:
		return L"PIV_INSUFFICIENT_CARD_RESOURCE";

	case PIV_UNSUPPORTED_CRYPTOGRAPHIC_MECHANISM:
		return L"PIV_UNSUPPORTED_CRYPTOGRAPHIC_MECHANISM";

	case PIV_CARD_READER_ERROR:
		return L"PIV_CARD_READER_ERROR";

	case PIV_INSUFFICIENT_BUFFER:
		return L"PIV_INSUFFICIENT_BUFFER";

	}

	return L"Unknown Error";
}
