/* ---------------------------------------------------------------------------
    2016 HID Global Corporation/ASSA ABLOY AB.  All rights reserved.

   Redistribution and use in source and binary forms, with or without modification,
   are permitted provided that the following conditions are met:
      - Redistributions of source code must retain the above copyright notice,
        this list of conditions and the following disclaimer.
      - Redistributions in binary form must reproduce the above copyright notice,
        this list of conditions and the following disclaimer in the documentation
        and/or other materials provided with the distribution.
        THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
        AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
        THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
        ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
        FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
        (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
        LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
        ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
        (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
        THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 --------------------------------------------------------------------------- */

#include "stdafx.h"

#include "Scenarios.h"
#include "Scenarios.UI.h"
#include "Helper.h"

#define MAIN_MENU		_T("Select a scenario:\n\t1. PIV signature\n\t2. PIV objects read\n\n\tQ. Quit\n")

// Sample commands
#define PIV_TEST_SIGNATURE		_T('1')
#define PIV_TEST_OBJECT_READ	_T('2')
#define PIV_QUIT				_T('Q')

int main(void)
{
	BOOL			bQuit = FALSE;
	WCHAR			cCommand;

	while (bQuit != TRUE)
	{
		wprintf_s (L"\n");
		DisplayMenuHeader();
		DisplayInputMenu(MAIN_MENU, L"%c", &cCommand);
		wprintf_s (L"\n");

		switch (cCommand)
		{
		case PIV_TEST_SIGNATURE:
			DisplayMenuHeader();

			wprintf_s(L"Starting PIV signature scenario...");
			wprintf_s(L"\n");
			wprintf_s(L"\n");

			if (TRUE == PIVSignature())
			{
				wprintf_s(L"\n");
				wprintf_s(L"\n");
				wprintf_s(L"PIV signature scenario completed.");
			}
			else
			{
				wprintf_s(L"\n");
				wprintf_s(L"PIV signature scenario aborted!");
			}
			break;

		case PIV_TEST_OBJECT_READ:
			DisplayMenuHeader();

			wprintf_s(L"Starting PIV objects read scenario...");
			wprintf_s(L"\n");
			wprintf_s(L"\n");

			if (TRUE == PIVObjectsRead())
			{
				wprintf_s(L"\n");
				wprintf_s(L"\n");
				wprintf_s(L"PIV objects read scenario completed.");
			}
			else
			{
				wprintf_s(L"\n");
				wprintf_s(L"PIV objects read scenario aborted!");
			}
			break; 

		case PIV_QUIT:
		case PIV_QUIT+32:
			bQuit = TRUE;
			break;

		default:
			wprintf_s (L"Unknown command!");
			break;
		}

		if (FALSE == bQuit)
		{
			wprintf_s(L"\n");
			wprintf_s(L"\n");
			system("PAUSE");
		}
	}

	return 0;
}
