/* ---------------------------------------------------------------------------
    2016 HID Global Corporation/ASSA ABLOY AB.  All rights reserved.

   Redistribution and use in source and binary forms, with or without modification,
   are permitted provided that the following conditions are met:
      - Redistributions of source code must retain the above copyright notice,
        this list of conditions and the following disclaimer.
      - Redistributions in binary form must reproduce the above copyright notice,
        this list of conditions and the following disclaimer in the documentation
        and/or other materials provided with the distribution.
        THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
        AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
        THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
        ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
        FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
        (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
        LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
        ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
        (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
        THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 --------------------------------------------------------------------------- */
 
#include "stdafx.h"

#include "Scenarios.h"
#include "Scenarios.UI.h"
#include "Helper.h"

static CHAR szVersion[BUFSIZ] = {0};
extern const CERTIFICATE_INFO g_certificateInfoTable[];
extern const OBJECT_INFO g_objectInfoTable[];


void DisplayMenuHeader()
{
	if (0 == szVersion[0])
	{
		PIV_RV			pivRet = PIV_OK;

		ZeroMemory(szVersion, sizeof(szVersion));

		pivRet = pivMiddlewareVersion(szVersion);
		if (PIV_OK != pivRet)
		{
			strcpy_s(szVersion, _countof(szVersion), "<Unknown>");
			wprintf(L"pivMiddlewareVersion - Return code: %s", GetPivErrorString(pivRet));
		}
	}

	system("CLS");
	wprintf_s(L"\n" LEGALCOPYRIGHT);
	wprintf_s(L"\n\n" PRODUCTNAME);
	wprintf_s(L"\n\n" DESCRIPTION, szVersion);
	wprintf_s(L"\n");
	wprintf_s(L"\n");

	wprintf_s(L"==================");
	wprintf_s(L"\n");
	wprintf_s(L"\n");
}


void DisplayInputMenu(LPCWSTR szMenu, LPCWSTR szFormat, LPVOID pArgument)
{
	WCHAR			szInputBuffer[BUFSIZ];

	wprintf_s(szMenu);

	GetString (L"Enter your choice", szInputBuffer, _countof(szInputBuffer));

	if (0 == wcscmp(szFormat, L"%d"))
	{
		swscanf_s (szInputBuffer, szFormat, (int*)pArgument);
	}
	else if (0 == wcscmp(szFormat, L"%u"))
	{
		swscanf_s (szInputBuffer, szFormat, (PDWORD)pArgument);
	}
	else if (0 == wcscmp(szFormat, L"%c"))
	{
		swscanf_s (szInputBuffer, szFormat, (LPWCH)pArgument, 1);
	}
}


void DisplayPINInput(LPBYTE ucPIN, PDWORD pcbPIN)
{
	WCHAR			szInputBuffer[BUFSIZ];
	size_t			unPINLength = 0;

	if ((NULL == ucPIN) || (NULL == pcbPIN))
	{
		wprintf_s (L"\n");
		wprintf_s (L"DisplayPINInput: bad parameter.");
		wprintf_s (L"\n");
		return;
	}

	GetString (L"Enter your PIN", szInputBuffer, _countof(szInputBuffer));

	unPINLength = wcslen(szInputBuffer);

	// swscanf_s required enough space for the terminating null character
	if ((unPINLength+1) > (*pcbPIN))
	{
		wprintf_s (L"\n");
		wprintf_s (L"ucPIN is too small.");
		wprintf_s (L"\n");
		return;
	}

	// PIN is a MBCS encoded byte array
	swscanf_s (szInputBuffer, L"%S", (LPSTR)ucPIN, *pcbPIN);
	wprintf_s (L"\n");

	// Return the PIN lenght without the terminating null character
	*pcbPIN = (DWORD)unPINLength;
}


//------------------------------------------------------------------
//	 Function: DisplayBinInHex
//
//	Display binary content in hexadecimal format
//		return	DWORD						: Error code
//		param	[IN] PBYTE pbData			: Binary data to be displayed
//		param	[IN] DWORD cbData			: Binary data length
//------------------------------------------------------------------
DWORD DisplayBinInHex(PBYTE pbData, DWORD cbData)
{
	DWORD		dwRet = ERROR_SUCCESS;
	DWORD		i = 0;

	if (NULL == pbData)
	{
		dwRet = ERROR_INVALID_PARAMETER;
		goto end_function;
	}

	/* control length of data to be displayed */
	if (0 == cbData)
	{
		wprintf_s(L"No data available");
	}
	else
	{
		for (i=0;i<cbData;i++)
		{
			wprintf_s(L"%02X ", pbData[i]);
		}
	}

end_function:
	return dwRet;
}


BOOL GetSelectedReader(LPSTR szSelectedReader, const DWORD cbSelectedReader)
{
	BOOL			bRet = FALSE ;

	WCHAR			szMenu[5000];
	DWORD			dwReader = 0;
	DWORD			dwReadersCount = 0;
	WCHAR			szReaderName[BUFSIZ];
	DWORD			dwReaderIndex = 0;
	PIV_ULong32		unTempLength = 0;
	CHAR			szReadersList[5000];
	DWORD			cbReadersList = _countof(szReadersList);
	LPSTR			szTempReadersList = NULL;

	if ((NULL == szSelectedReader) || (0 == cbSelectedReader))
	{
		wprintf_s (L"GetSelectedReader: bad parameter.");
		goto end_function;
	}

	// Try to list readers
	if (ERROR_SUCCESS != ListReaders(szReadersList, &cbReadersList))
	{
		goto end_function;
	}

	if (0 == cbReadersList)
	{
		// No reader available
		wprintf_s (L"No smart card reader connected.");

		goto end_function;
	}

	swprintf_s(szMenu, _countof(szMenu), L"Select a reader:");

	szTempReadersList = szReadersList;

	// Build the list
	while(*szTempReadersList != '\0' && unTempLength < cbReadersList-1)
	{
		dwReadersCount++;
		swprintf_s(szReaderName, _countof(szReaderName), L"\n\t- %u. %S", dwReadersCount, szTempReadersList);
		wcscat_s(szMenu, _countof(szMenu), szReaderName);
		unTempLength += (PIV_ULong32)strlen(szTempReadersList)+1;
		szTempReadersList += strlen(szTempReadersList)+1;
	}

	wcscat_s(szMenu, _countof(szMenu), L"\n");

	if (0 == dwReadersCount)
	{
		// No reader available
		wprintf_s (L"No reader connected.");

		goto end_function;
	}

	DisplayInputMenu(szMenu, L"%u", &dwReader);

	// Verify the input
	if ((0 == dwReader) || (dwReader > dwReadersCount))
	{
		wprintf_s (L"\n");
		wprintf_s (L"Bad reader index.");
		goto end_function;
	}

	szTempReadersList = szReadersList;
	unTempLength = 0;

	// Parse the readers list
	while((*szTempReadersList != '\0') && (unTempLength < cbReadersList-1))
	{
		dwReaderIndex++;
		if (dwReader == dwReaderIndex)
		{
			// Return with the selected reader name
			break;
		}
		unTempLength += (PIV_ULong32)strlen(szTempReadersList)+1;
		szTempReadersList += strlen(szTempReadersList)+1;
	}

	// Save the current reader name from the list
	strcpy_s(szSelectedReader, cbSelectedReader, szTempReadersList);
	bRet = TRUE;

end_function:
	wprintf_s (L"\n");

	return bRet ;
}


CERTIFICATE_INDEX GetSelectedCertificate(const PIV_CARDHANDLE cardHandle)
{
	CERTIFICATE_INDEX		nSelectedCertificate = CERTIFICATE_INDEX_NO_CERTIFICATE;

	WCHAR			szMenu[5000];
	WCHAR			szCertificateLabel[BUFSIZ];
	LPSTR			pCertificateLabel = NULL;
	DWORD			dwSelectedMenu = 0;
	CERTIFICATE_INDEX		certificates[CERTIFICATE_INDEX_CARD_AUTHENTICATION+1];
	DWORD			cbCertificates = _countof(certificates);
	DWORD			i = 0;

	if (INVALID_CARD_HANDLE == cardHandle)
	{
		wprintf_s (L"GetSelectedCertificate: bad parameter.");
		goto end_function;
	}

	// Initialize array to NO_CERTIFICATE
	for (i=0; i<_countof(certificates); i++)
	{
		certificates[i] = CERTIFICATE_INDEX_NO_CERTIFICATE;
	}

	// List certificates
	if (ERROR_SUCCESS != ListCertificates(cardHandle, certificates, &cbCertificates))
	{
		goto end_function;
	}

	if (0 == cbCertificates)
	{
		// No certificate available
		wprintf_s (L"\n");
		wprintf_s (L"No certificate available.");
		goto end_function;
	}

	swprintf_s(szMenu, _countof(szMenu), L"Select a certificate:");

	for (i=0; i<cbCertificates; i++)
	{
		pCertificateLabel = g_certificateInfoTable[i].szCertificateLabel;

		swprintf_s(szCertificateLabel, _countof(szCertificateLabel), L"\n\t- %u. %S", i+1, pCertificateLabel);
		wcscat_s(szMenu, _countof(szMenu), szCertificateLabel);
	}

	wcscat_s(szMenu, _countof(szMenu), L"\n");

	DisplayInputMenu(szMenu, L"%u", &dwSelectedMenu);

	if ((0 == dwSelectedMenu) || (dwSelectedMenu > cbCertificates))
	{
		wprintf_s (L"\n");
		wprintf_s (L"Bad certificate index.");
		goto end_function;
	}

	nSelectedCertificate = certificates[dwSelectedMenu-1];

end_function:
	wprintf_s (L"\n");

	return nSelectedCertificate ;
}


OBJECT_INDEX GetSelectedObject(const PIV_CARDHANDLE cardHandle)
{
	OBJECT_INDEX	nSelectedObject = OBJECT_INDEX_NO_OBJECT;

	WCHAR			szMenu[5000];
	WCHAR			szObjectLabel[BUFSIZ];
	LPSTR			pObjectLabel = NULL;
	DWORD			dwSelectedMenu = 0;
	OBJECT_INDEX	objects[OBJECT_INDEX_CARDHOLDER_IRIS_IMAGES+1];
	DWORD			cbObjects = _countof(objects);
	DWORD			i = 0;

	if (INVALID_CARD_HANDLE == cardHandle)
	{
		wprintf_s (L"GetSelectedObject: bad parameter.");
		goto end_function;
	}

	// Initialize array to NO_OBJECT
	for (i=0; i<_countof(objects); i++)
	{
		objects[i] = OBJECT_INDEX_NO_OBJECT;
	}

	// Try to list piv objects
	if (ERROR_SUCCESS != ListObjects(cardHandle, objects, &cbObjects))
	{
		goto end_function;
	}

	if (0 == cbObjects)
	{
		// No piv object available
		wprintf_s (L"\n");
		wprintf_s (L"No piv object available.");
		goto end_function;
	}

	swprintf_s(szMenu, _countof(szMenu), L"Select a piv object:");

	for (i=0; i<cbObjects; i++)
	{
		pObjectLabel = g_objectInfoTable[i].szObjectLabel;

		swprintf_s(szObjectLabel, _countof(szObjectLabel), L"\n\t- %u. %S", i+1, pObjectLabel);
		wcscat_s(szMenu, _countof(szMenu), szObjectLabel);
	}

	wcscat_s(szMenu, _countof(szMenu), L"\n");

	DisplayInputMenu(szMenu, L"%u", &dwSelectedMenu);

	if ((0 == dwSelectedMenu) || (dwSelectedMenu > cbObjects))
	{
		wprintf_s (L"\n");
		wprintf_s (L"Bad piv object index.");
		goto end_function;
	}

	nSelectedObject = objects[dwSelectedMenu-1];

end_function:
	wprintf_s (L"\n");

	return nSelectedObject;
}
