/* ---------------------------------------------------------------------------
    2016 HID Global Corporation/ASSA ABLOY AB.  All rights reserved.

   Redistribution and use in source and binary forms, with or without modification,
   are permitted provided that the following conditions are met:
      - Redistributions of source code must retain the above copyright notice,
        this list of conditions and the following disclaimer.
      - Redistributions in binary form must reproduce the above copyright notice,
        this list of conditions and the following disclaimer in the documentation
        and/or other materials provided with the distribution.
        THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
        AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
        THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
        ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
        FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
        (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
        LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
        ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
        (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
        THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 --------------------------------------------------------------------------- */

package ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;

import javax.swing.*;

// Popup asking for the PIN
public class PINDialog extends JDialog 
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	//	{{DECLARE_CONTROLS
	JTextField 	m_textField1 = new JPasswordField();
	JButton 	m_buttonOk = new JButton();
	JButton 	m_buttonCancel = new JButton();
	JTextArea 	m_staticField = new JTextArea(null, 2, 0);
	//}}
	
	boolean m_bCanceled;	//	To know if the user has canceled or not.
	
	//	Constructor
	public PINDialog(JFrame aFrame, String aTitle, String defValue)
	{
	    super(aFrame, aTitle, true);
	    
	    m_bCanceled = false;
	
		//{{INIT_CONTROLS
		setLayout(null);
		int iDialogWidth = 275;
		setSize(iDialogWidth, 103);
		Point frameLoc = aFrame.getLocation();
	    Dimension frameDim = aFrame.getSize();
		setLocation(frameLoc.x+(frameDim.width-getWidth())/2, frameLoc.y+(frameDim.height-getHeight())/2);
		
		add(m_textField1);
		m_textField1.setBounds(5, 5, 250, 24);
		
		//	Align the ok and cancel button horizontally.
		m_buttonOk.setText("OK");
		add(m_buttonOk);
		
		int iDialogButtonWidth = 84;
		int iSpaceBetweenButtons = 20;
		int x0 = (iDialogWidth - (2*iDialogButtonWidth + iSpaceBetweenButtons))/2;
		m_buttonOk.setBackground(Color.lightGray);
		m_buttonOk.setBounds(x0, 34, iDialogButtonWidth, 24);
		
		m_buttonCancel.setText("Cancel");
		add(m_buttonCancel);
	
		m_buttonCancel.setBackground(Color.lightGray);
		m_buttonCancel.setBounds(x0+iDialogButtonWidth+iSpaceBetweenButtons, 34, 
				                 iDialogButtonWidth, 24);
		//}}
	
		//{{REGISTER_LISTENERS
		SymAction lSymAction = new SymAction();
		m_buttonOk.addActionListener(lSymAction);
		m_buttonCancel.addActionListener(lSymAction);
		//}}
		
		if(defValue != null)
		    m_textField1.setText(defValue);
		
		getRootPane().setDefaultButton(m_buttonOk);

		setVisible(true);
	} // end constructor
	
	class SymAction implements java.awt.event.ActionListener
	{
		public void actionPerformed(java.awt.event.ActionEvent event)
		{
			Object object = event.getSource();
			if (object == m_buttonOk)
				buttonok_ActionPerformed(event);
			else if (object == m_buttonCancel)
				buttoncancel_ActionPerformed(event);
		}
	}

	void buttonok_ActionPerformed(java.awt.event.ActionEvent event)
	{
        m_bCanceled = false;
		dispose();
	}
	
	void buttoncancel_ActionPerformed(java.awt.event.ActionEvent event)
	{
        m_bCanceled = true;
		dispose();
	}
	
	public String getString()
    {
        return m_textField1.getText();
    }
}
